#include "L3GD20.h"

#define CS_GPIOx    GPIOA
#define CS_GPIO_Pin GPIO_PIN_3

gyro_t l3gd20;

/*----------------SPI module-----------------*/
static SPI *spi_ptr = &spi1;			//use SPI1
static DigitalOut *cs_ptr = &spi1_cs1;	//CS pin
/*-------------------------------------------*/

void L3GD20_Init()
{
	*cs_ptr = 1;	//CS high
	HAL_Delay(10);
	
	/*-----configuration-----*/
	*cs_ptr = 0;	//CS low
	(*spi_ptr).write(CTRL_REG1);
	(*spi_ptr).write(0xCF);
	*cs_ptr = 1;	//CS high
	HAL_Delay(50);
	
	*cs_ptr = 0;	//CS low
	(*spi_ptr).write(CTRL_REG4);
	(*spi_ptr).write(0x30);
	*cs_ptr = 1;	//CS high
	/*-----------------------*/

#if 0
			spi_tx[0] = WHO_AM_I | L3GD20_RW;
			spi_tx[1] = 0x00;
			HAL_GPIO_WritePin(CS_GPIOx, CS_GPIO_Pin, GPIO_PIN_RESET);
			HAL_SPI_TransmitReceive(&hspi1, spi_tx, spi_rx, 2, 10);
			HAL_GPIO_WritePin(CS_GPIOx, CS_GPIO_Pin, GPIO_PIN_SET);

			//printf("who am i = 0x%x\n", spi_rx[1]);
			//while(spi_rx[1] == 0xFF);
#endif
	
}

void L3GD20_Read()
{
    uint32_t i;
    
    *cs_ptr = 0;	//CS low
    //"0x40" MUST be added to increment the resister address
    (*spi_ptr).write(OUT_X_L | L3GD20_RW | 0x40);
    
	for(i = 0; i < 6; i ++)
	{
		//spi_rx[0] is an invalid byte
		//so this process starts with spi_rx[1]
		spi_rx[i+1] = (*spi_ptr).write(0x00);	//dummy data
	}
	
	*cs_ptr = 1;	//CS high
	
	l3gd20.x = ((int32_t)spi_rx[1]+((int32_t)spi_rx[2]<<8));
	l3gd20.y = ((int32_t)spi_rx[3]+((int32_t)spi_rx[4]<<8));
	l3gd20.z = ((int32_t)spi_rx[5]+((int32_t)spi_rx[6]<<8));
	
	if(l3gd20.z > 32768)
	{
		l3gd20.z = l3gd20.z - 65535 + 6;
	}
}
