#include "GP2Y0E03.h"

const float d_max = 0.50f;
const float d_min = 0.04f;
const float v_max = 2.20f;
const float v_min = 0.55f;

float Get_Distance(float vin)
{
    //return val: distance [m]
    
    float dist;
    
    dist = 0.6576f - vin * (d_max-d_min) / (v_max-v_min);   
    if (dist> d_max)   //測定限界
    {
        return 0.0f;
    }
    
    return dist;
}