#include "mbed.h"
#include "class_hardware.h"

Motor::Motor(PinName pin_pwm, PinName pin_fwd, PinName pin_rev) :
	pwm(pin_pwm), fwd(pin_fwd), rev(pin_rev) {
		pwm=0;
		pwm.period(0.001);
		fwd=0; rev=0;
	}

void Motor::stop() {
	pwm=0;
	fwd=0; rev=0;
}

void Motor::stop(bool powered) {
	pwm=0;
	if ( powered )
		{ fwd=1; rev=1; }
	else
		{ fwd=0; rev=0; }
}

void Motor::set(int speed) {
	if ( speed > 0 ) {
		pwm=( (float)(speed) / 100 );
		fwd=1; rev=0;
	}
	else if ( speed < 0 ) {
		pwm=( (float)(speed) / -100 );
		fwd=0; rev=1;
	}
	else
		{ pwm=0; fwd=0; rev=0; }
}

IRSensor::IRSensor(PinName pin_ir) :
	ir(pin_ir) {
		threshold = 500;
	}

IRSensor::IRSensor(PinName pin_ir, int threshold_black) :
	ir(pin_ir) {
		threshold = threshold_black;
	}

bool IRSensor::is_black() {
	if ( ir.read_u16()>>6 > threshold )
		return true;
	
	return false;
}

int IRSensor::get_data() {
	return ( ir.read_u16()>>6 );
}

USSensor::USSensor(PinName pin_trigger, PinName pin_echo) :
	trigger(pin_trigger),echo(pin_echo) {
		echo.rise(this, &USSensor::on_rise);
		echo.fall(this, &USSensor::on_fall);
		
		distance = 50;
	}

USSensor::USSensor(PinName pin_trigger, PinName pin_echo, int distance_set_bool) :
	trigger(pin_trigger),echo(pin_echo) {
		echo.rise(this, &USSensor::on_rise);
		echo.fall(this, &USSensor::on_fall);
		
		if (distance_set_bool < 4000 && distance_set_bool > 20)
			distance = distance_set_bool;
		else
			distance = 50;
	}

void USSensor::initialize() {
	ticker.attach(this, &USSensor::measure, 0.06);
	timer.start();
}

void USSensor::measure() {
	trigger=1;
	wait_us(10);
	trigger=0;
}

void USSensor::on_rise() {
	timer.reset();
}

void USSensor::on_fall() {
	distance_mm = ( (float)(timer.read_us()) * 1716E-4 );
	
	if ( distance_mm < distance )
		in_distance = true;
	else
		in_distance = false;
}

