#include "mbed.h"
#include "class_hardware.h"
#include "class_software.h"
#include "hl_bertl_portex.h"
#include "functions_bertl.h"

void line_turn(unsigned char linesegment, int speed, Motor left, Motor right) {
	
	if ( speed < 30 )
		speed = 30;
	
	switch (linesegment) {
		case 0b00000: left.set(speed * 0.80); right.set(speed * -0.80); break;
		case 0b00100: left.set(speed * 1.50); right.set(speed * 1.50); break;
		
		// Nach links
		case 0b01100: left.set(speed * 0.65); right.set(speed * 1.00); break;
		case 0b01000: left.set(speed * 0.35); right.set(speed * 0.80); break;
		case 0b11000: left.set(speed * 0.30); right.set(speed * 0.90); break;
		case 0b10000: left.set(speed * -0.40); right.set(speed * 0.40); break;
		
		// Nach rechts
		case 0b00110: left.set(speed * 1.00); right.set(speed * 0.65); break;
		case 0b00010: left.set(speed * 0.80); right.set(speed * 0.35); break;
		case 0b00011: left.set(speed * 0.90); right.set(speed * 0.30); break;
		case 0b00001: left.set(speed * 0.40); right.set(speed * -0.40); break;
	}
}


unsigned char sensor_to_byte(IRSensor LL, IRSensor L, IRSensor M, IRSensor R, IRSensor RR) {
    unsigned char sensor_byte = 0b00000;
    
    if (LL.is_black()) sensor_byte += 0b10000;
    if (L.is_black())  sensor_byte += 0b01000;
    if (M.is_black())  sensor_byte += 0b00100;
    if (R.is_black())  sensor_byte += 0b00010;
    if (RR.is_black()) sensor_byte += 0b00001;
    
    return sensor_byte;
}

void initialize(PinName power_motor, PinName power_ir, PortEx portex) {
	BusOut power (power_motor, power_ir);
	power = 0xff;
	BusOut leds(LED1,LED2,LED3,LED4);
	leds = 0x00;
	
	portex.useISR=0;
	portex.ClearLeds();
	portex.WaitUntilButtonPressed();
}