#ifndef class_hardware
#define class_hardware

class Motor {
	//functions
	public:
		Motor(PinName pin_pwm, PinName pin_fwd, PinName pin_rev);
		void stop();
		void stop(bool powered);
		void set(int speed);
	//variables
	private:
		PwmOut pwm;
		DigitalOut fwd;
		DigitalOut rev;
};

class IRSensor {
	//functions
	public:
		IRSensor(PinName pin_ir);
		IRSensor(PinName pin_ir, int threshold_black);
		bool is_black();
		int get_data();
	//variables
	private:
		AnalogIn ir;
		int threshold;
};

class USSensor {
	//functions
	public:
		USSensor(PinName pin_trigger, PinName pin_echo);
		USSensor(PinName pin_trigger, PinName pin_echo, int distance_set_bool);
		void initialize();
	private:
		void on_rise();
		void on_fall();
		void measure();
	//variables
	public:
		bool in_distance;
		int distance_mm;
	private:
		DigitalOut trigger;
		InterruptIn echo;
		Timer timer;
		Ticker ticker;
		int distance;
};

#endif

