#include "mbed.h"

AnalogIn ai_uva(A1);
AnalogIn ai_uvb(A2);
AnalogIn ai_pyrLL(A3);
AnalogIn ai_pyrHL(A0);
AnalogIn ai_temp(A4);


DigitalOut led(LED1);

int main()
{
    unsigned short uva;         // UVA sensor (16-bit ADC code)
    unsigned short uvb;         // UVB sensor (16-bit ADC code)
    unsigned short pyrLL;       // pyranometer sensor for low lighting conditions (16-bit ADC code)
    unsigned short pyrHL;       // pyranometer sensor for high lighting conditions (16-bit ADC code)
    unsigned short temp;        // 10K NTC sensor (16-bit ADC code)
    
    printf("\n# LightSense - David Picard, LaMP, 2019\n");
    printf("# uint16 : 0..65535\n");
    printf("# UVA\tUVB\tpyr LL\tpyr HL\tTemp\n");

    while(1)
    {
        uva = ai_uva.read_u16();
        uvb = ai_uvb.read_u16();
        pyrLL = ai_pyrLL.read_u16();
        pyrHL = ai_pyrHL.read_u16();
        temp = ai_temp.read_u16();
        
        printf("%5d\t%5d\t%5d\t%5d\t%5d\n", uva, uvb, pyrLL, pyrHL, temp);   // print measurements
        
        // Blink LED with at a 1Hz frequency :
        led = !led;     // toggle LED
        wait(0.5);      // wait for 0.5s
        led = !led;     // toggle LED
        wait(0.5);      // wait for 0.5s
    }
}
