#include "mbed.h"
#include "edge_time.h"
#include "pending.h"

/*
class pending_class {
public:
pending_class() ;
~pending_class() ;

request_t *request ;
uint32_t submit_time ;
uint32_t replied_time ;
} ;
*/

pending_class::pending_class()
{
    submit_time = edge_time ; /* save current time */
    replied_time = 0 ;
    request = new request_t ;
    request->messageType = 0 ;
    request->attrId = 0 ;
    request->requestId = 0 ;
    request->valueLen = 0 ;
    request->p_value = new uint8_t[256] ;
}

pending_class::pending_class(
    uint8_t     messageType, 
    uint16_t    attrId, 
    uint8_t     requestId, 
    uint16_t    valueLen, 
    uint8_t     *value
) 
{
    submit_time = edge_time ; /* save current time */
    replied_time = 0 ;
    request = new request_t ;
    request->p_value = new uint8_t[256] ;
    request->messageType = messageType ;
    request->attrId = attrId ;
    request->requestId = requestId ;
    request->valueLen = valueLen ;
    memcpy(request->p_value, value, valueLen) ;
}

pending_class::~pending_class()
{
    submit_time = 0 ;
    replied_time = 0 ;
    delete [] request->p_value ;
    request->p_value = 0 ;
    delete request ;
}