#include "mbed.h"
#include "LM75B.h"
#include "edge_reset_mgr.h"
#include "edge_sensor.h"
#include "edge_temp.h"
#include "edge_chart.h"

float *current_temp = 0 ;

edge_temp::edge_temp(LM75B *temp1, SMTC502AT *temp2, SMTC502AT *temp3, LM75B *temp4) 
{
    _temp1 = temp1 ;
    _temp2 = temp2 ;
    _temp3 = temp3 ;
    _temp4 = temp4 ;
    _ftemp[0] = _ftemp[1] = _ftemp[2] = _ftemp[3] = 0.0 ;
    _interval = 30 ;
    current_temp = &_ftemp[1] ; /* use before for current temp */
}

edge_temp::~edge_temp(void)
{
    if (_temp1) {
        delete _temp1 ;
    }
    if (_temp2) {
        delete _temp2 ;
    }
    if (_temp3) {
        delete _temp3 ;
    }
    if (_temp4) {
        delete _temp4 ;
    }
}

void    edge_temp::reset(void) 
{
}

void    edge_temp::prepare(void) 
{
}

int    edge_temp::sample(void) 
{
    int result ;
    if (_temp1) {
        result = _temp1->getTemp(&_ftemp[0]) ;
    }
    if (_temp2) {
        _ftemp[1] = _temp2->getTemp() ;
    }
    if (_temp3) {
        _ftemp[2] = _temp3->getTemp() ;
    }
    if (_temp4) {
        _temp4->getTemp(&_ftemp[3]) ;
    }
    _sampled_time = edge_time ;
    return( result ) ;
}

int    edge_temp::deliver(void) 
{
    int result ;
    char timestr[16] ;
    
    print_time() ;
    printf(" temp: ") ;
    if (_temp1) {
        printf("LM75B1 = %.2f ", _ftemp[0]) ;
    } 
    if (_temp2) {
        printf("before = %.2f ", _ftemp[1]) ;
    }
    if (_temp3) {
        printf("after = %.2f ", _ftemp[2]) ;
    }
    if (_temp4) {
        printf("LM75B2 = %.2f ", _ftemp[3]) ;
    }
    printf("\n") ;
    time2seq(_sampled_time, timestr) ;
    sprintf(_str_buf,
    "{\"DEVICE\":\"TEMP04\",\"VAL_1\":\"%.1f\",\"VAL_2\":\"%.1f\",\"VAL_3\":\"%.1f\",\"T\":\"%s\",\"E\":\"%d\"}",
        _ftemp[0], _ftemp[1], _ftemp[2], timestr, _error_count) ;
    result = afero->setAttribute(1, _str_buf) ;
    return( result == afSUCCESS ) ;
}

int temp_v2y(float value, edge_chart_type *p)
{
    int y ;
    if (value < p->min) {
        value = p->min ;
    } else if (value > p->max) {
        value = p->max ;
    }
    y = p->top + p->height - 1
        - (int)((p->height - 2) * (value - p->min) /(p->max - p->min)) ;
    return( y ) ;
}

void edge_temp::show(void)
{
    edge_chart_type *p = &edge_chart[ _id ] ;
    int x, temp, before, after ;
    reset_watch_dog() ;
    if (display) {
        switch(display_mode) {
        case DISPLAY_MODE_SUMMARY:
            display->BusEnable(true) ;
            display->set_font((unsigned char*) Arial12x12);
            display->set_font_zoom(2, 2) ;
            display->foreground(White) ;
            display->locate(EDGE_SUMMARY_X, EDGE_SUMMARY_TIME_Y) ;
            displayTime(_sampled_time) ;
            display->locate(EDGE_SUMMARY_X, EDGE_SUMMARY_TEMP_Y) ;
            display->printf("Temp : %.2f %.2f %.2f",_ftemp[0], _ftemp[1], _ftemp[2]) ;
            display->BusEnable(false) ;
            reset_watch_dog() ;
            break ;
        case DISPLAY_MODE_CHART:
            x = p->left + p->index + 1;
            temp =  temp_v2y(_ftemp[0], p) ;
            before = temp_v2y(_ftemp[1], p) ;
            after = temp_v2y(_ftemp[2], p) ;
            display->BusEnable(true) ;
            if (p->index == 0) {
                draw_chart_frame(p) ;
            }
            display->pixel(x, temp, White) ;
            display->pixel(x, before, Red) ;
            display->pixel(x, after, Blue) ;
            display->BusEnable(false) ;
            p->index = (p->index + 1) % (p->width - 2) ;
            break ;  
        }
    }
    reset_watch_dog() ;
}

