#ifndef _EDGE_TIME_H_
#define _EDGE_TIME_H_
#include "mbed.h"

void init_timer(void) ;
void set_time(const uint16_t  valueLen, const uint8_t *value) ;
void ts2time(uint32_t timestamp, struct tm *tm) ; /* light version */
void ts2tm(uint32_t timestamp, struct tm *date) ; /* full version */
void print_time(void) ; /* light version */
void print_time(uint32_t thetime) ;
void print_time(struct tm *tm) ; /* light version */
void print_date(struct tm *date) ; /* full version */
void print_date_wd(struct tm *date) ; /* vull version with day of week */
void time2str(char *timestr) ; /* light version */
int32_t time2seq(uint32_t timestamp) ; /* hhmmss */
void time2seq(uint32_t timestamp, char *timestr) ;
void time2str(struct tm *tm, char *timestr) ; /* hh:mm:ss */
void time2date(struct tm *tm, char *datestr) ; /* YYYY/MM/DD hh:mm:ss */
void time2date(struct tm *tm, char *datestr) ; /* full version with day of week */

extern const char *nameOfDay[] ;
extern tm current_time ;
extern uint32_t edge_time ;
extern uint32_t utc_offset ;
#endif /* _EDGE_TIME_H_ */
