#ifndef _EDGE_ACCEL_H_
#define _EDGE_ACCEL_H_
#include "mbed.h"
#include "edge_sensor.h"
#include "MMA8451Q.h"

/**
 * edge_accel edge_sensor which manage the accelerometer sensor (MMA8451Q)
 * @note The behavior of this class is somewhat exceptional as an edge_sensor
 * @note it samples and accumulates data which is the abs sum of current
 * @note values and previous values every 0.1 sec
 * @note and in each "interval" it delivers the averaged value 
 */

class edge_accel : public edge_sensor {
public:
/**
 * constructor
 * @param the MMA8451Q object
 */
    edge_accel(MMA8451Q *accel) ;
    
/**
 * destructor
 */
    ~edge_accel(void) ;

/**
 * clear and reset interval values
 */
    virtual void    reset(void) ;
//    virtual void    prepare(void) ;

/**
 * sample calculate the average value
 * from _accumulation and _sample_count
 * the average value is assigned to _value
 * and currnt _sample_count is stored in _num_sampled
 * then both _accumuation and _sample_count will be cleared
 * @returns 0: success non-0: failure
 */
    virtual int    sample(void) ;
    
/**
 * deliver the value to the afero cloud
 */
    virtual int     deliver(void) ;
    
/**
 * show the data in the display (TFT)
 */
    virtual void    show(void) ;
        
/**
 * accum this is the real sampling
 * and the differences of sampled values 
 * and previous values are calcurated and accumulated
 * @returns 0: success non-0: failure
 */
    int accum(void) ;
    
/**
 * Clear internal values
 */
    void clear_value(void) ;

private:
    MMA8451Q *_accel ;
    float   _value ;
    int32_t _num_sampled ;
    int32_t _sample_count ;
    int32_t _accumulation ;
    int16_t _prev_x ;
    int16_t _prev_y ;
    int16_t _prev_z ;
} ;

#endif /* _EDGE_ACCEL_H_ */