#include "mbed.h"
#include "vt100.h"
#include "afSPI.h"
#include "mbedSPI.h"

#if defined (TARGET_KL25Z) || defined (TARGET_TEENSY3_1)
 #ifndef SPI0_C1
  #define SPI0_C1 (*(uint8_t *)0x40076000)
 #endif
#endif
/*
class mbedSPI : public afSPI {
public:
    mbedSPI(PinName mosi, PinName miso, PinName sckl, PinName cs) ;
    virtual void begin() ;
    virtual void beginSPI() ;
    virtual void endSPI() ;
    virtual void transfer(char *bytes,int len) ;
private:
    SPI         _spi ;
    DigitalOut  _cs ;
} ;
*/

mbedSPI::mbedSPI(PinName mosi, PinName miso, PinName sckl, PinName cs) :
    _spi(mosi, miso, sckl), _cs(cs, 1)
{
    _spi.format(8, 0) ;
    _spi.frequency(1000000) ; /* 1MHz */

#if defined (TARGET_KL25Z) || defined (TARGET_TEENSY3_1)
    #ifndef SPI0_C1
        #define SPI0_C1 (*(uint8_t *)0x40076000)
    #endif
//    SPI0_C1 |= 0x01 ; /* LSB First */
//    SPI0_C1 &= 0xFE ; /* MSB First */
#endif

}

void mbedSPI::begin(void)
{
}

void mbedSPI::beginSPI()
{
//    printf("+") ; fflush(stdout) ;
    _cs = 0 ;
    SPI0_C1 |= 0x01 ; /* LSB First */
    wait_us(1) ;
}

void mbedSPI::endSPI()
{
    _cs = 1 ;
    SPI0_C1 &= 0xFE ; /* MSB First */
    wait_us(1) ;
//    printf("-") ; fflush(stdout) ;
}

/**
 * on 17-Jan-2018 disable/enable irq added
 * before and after of each _spi.writes
 */
void mbedSPI::transfer(char *bytes, int len)
{
    int i ;
    for (i = 0 ; i < len ; i++ ) {
        __disable_irq() ; // Disable Interrupts
        bytes[i] = _spi.write(bytes[i]) ;
        __enable_irq() ; // Enable Interrupts
    }
}

