#include "mbed.h"
#include "string.h"
#include "vt100.h"
#include "edge_time.h"
#include "edge_pin.h"
#include "edge_reset_mgr.h"
#include "afLib.h"
#include "pending.h"
#include "msg_types.h"
#include "mbedSPI.h"
#include "af_mgr.h"

afLib           *afero = 0 ;
pending_class   *pending = 0 ;
InterruptIn     *afero_int = 0 ;
mbedSPI         *afero_spi = 0 ;
DigitalOut      *afero_reset ;
bool            gLinked = false ;
bool            gConnected = false ;

void afero_isr(void)
{
    afero->mcuISR() ;
}

void init_aflib(void)
{
    afero_reset = new DigitalOut(PIN_ASR_RESET, 1) ; /* create as deasserted */
    afero_spi = new mbedSPI(PIN_MOSI, PIN_MISO, PIN_SCK, PIN_CS) ;

reset_watch_dog() ;
    afero = new afLib(
        PIN_INTR,
        afero_isr,
        attributeChangeRequest,
        attributeUpdatedReport,
        afero_spi ) ;
reset_watch_dog() ;
    wait(0.1) ;
    *afero_reset = 0 ;
    wait(0.5) ; /* required 250ms ~ time for reset */
    *afero_reset = 1 ; 
reset_watch_dog() ;      
    wait(0.5) ;
reset_watch_dog() ;
}