#ifndef _SMTC502AT_H_
#define _SMTC502AT_H_

#include "mbed.h"

/** 
 * Semitec 502AT-11 temperature sensor 
 */
 
class SMTC502AT {
public:
/**
 * constructor
 * @param *ain AnalogIn object
 * @param R0 5.0 ohm (default)
 * @param R1 4.95 ohm (default)
 * @param B 3324 (default)
 * @param T0 298.15 (default)
 */
    SMTC502AT(AnalogIn *ain, float R0=5.0, float R1=4.95, float B=3324, float T0=298.15) ;

/**
 * destructor
 */
    ~SMTC502AT(void) ;
    
/**
 * getTemp get temperature
 * @returns temperature in float format
 */
    float getTemp(void) ;
private:
    AnalogIn *_ain ;
    float _r0 ;
    float _r1 ;
    float _b ;
    float _t0 ;
} ;

#endif /* _SMTC502AT_H_ */