#include "mbed.h"
#include "edge_mgr.h"
#include "edge_reset_mgr.h"
#include "edge_chart.h"
#if 0
typedef struct _edge_chart_st {
    char *name ;
    int left ;
    int top ;
    int width ;
    int height ;
    int index ;
    int min ;
    int max ;
} edge_chart_type ;

extern edge_chart_type edge_chart[] ;
#endif

edge_chart_type edge_chart[] = {
/*      name,  left, top, width, height, index,   min,     max */
    { "Accel",    0,   0,   160,     60,     0,  -0.2,     0.2 },
    { "Color",  160,   0,   160,    120,     0,   0.0, 10000.0 },
    { "Color2", 160, 120,   160,    120,     0,   0.0, 10000.0 },
    { "Temp",     0, 120,   160,    120,     0, -10.0,    50.0 },
    { "Press",    0,  60,   160,     60,     0,  -1.0,     5.0 },
    {        0,   0,   0,     0,      0,     0,   0.0,     0.0 }
} ;

void draw_chart_frame(edge_chart_type *p)
{
    if (display) {
        display->fillrect(p->left+1, p->top+1,
        p->left + p->width - 2, p->top + p->height - 2, Black) ;
        display->rect(p->left, p->top, 
            p->left + p->width - 1,
            p->top + p->height -1, Blue) ;
        display->set_font((unsigned char*) Arial12x12);
        display->foreground(White) ;
        display->locate(p->left + 5, p->top + 5) ;
        display->printf(p->name) ;
    }
}

void   draw_all_chart_frame(void) 
{
    edge_chart_type *p ;
    if (display) {
        reset_watch_dog() ;
        display->BusEnable(true) ;
        for(p = edge_chart ; p->name ; p++ ) {
            draw_chart_frame(p) ;
        }
        display->BusEnable(false) ;
    }
}