#ifndef _EDGE_TEMP_H_
#define _EDGE_TEMP_H_
#include "mbed.h"
#include "edge_sensor.h"
#include "LM75B.h"
#include "SMTC502AT.h"

/**
 * edge_temp edge_sensor to measre temperature sensors
 */

class edge_temp : public edge_sensor {
public:
/**
 * constructor
 * @param *temp1 LM75B temperature sensor object (with Color1)
 * @param *temp2 SMTC502AT temperature sensor object (befor)
 * @param *temp3 SMTC502AT temperature sensor object (after)
 * @param *temp4 LM75B temperature sensor object (with Color2)
 */
    edge_temp(LM75B *temp1, SMTC502AT *temp2, SMTC502AT *temp3, LM75B *temp4) ;
    
/**
 * destructor
 */
    ~edge_temp(void) ;
    
/**
 * reset and clear the internal values
 */
    virtual void    reset(void) ;

/**
 * prepare for sampling 
 */
    virtual void    prepare(void) ;
    
/**
 * sample measure and store sensor values
 * @return 0: success non-0: failure
 */
    virtual int    sample(void) ;
    
/**
 * deliver the values to the afero cloud
 */
    virtual int     deliver(void) ;
    
/**
 * Show the value(s) in the display (TFT)
 */
    virtual void    show(void) ;

private:
    LM75B       *_temp1 ;
    SMTC502AT   *_temp2 ;
    SMTC502AT   *_temp3 ;
    LM75B       *_temp4 ;
    float       _ftemp[4] ;
} ;

extern float *current_temp ;
#endif /* _EDGE_TEMP_H_ */