#ifndef _EDGE_PRESSURE_H_
#define _EDGE_PRESSURE_H_
#include "mbed.h"
#include "edge_sensor.h"
#include "PSE530.h"

/**
 * edge_pressure edge_sensor for measuring gas presssure
 */

class edge_pressure : public edge_sensor {
public:
/**
 * constructor 
 * @param *pse PSE530 pressure sensor object
 */
    edge_pressure(PSE530 *pse, DigitalOut *en) ;

/**
 * destructor
 */
    ~edge_pressure(void) ;
    
/**
 * reset and clear internal values
 */
    virtual void    reset(void) ;

/**
 * prepare for sampling (not used)
 */
    virtual void    prepare(void) ;
    
/**
 * sample the value
 * @returns 0: success non-0: failure
 */
    virtual int    sample(void) ;

/**
 * deliver the sampled value to afero cloud
 */
    virtual int     deliver(void) ;
    
/**
 * show the value in the display (TFT)
 */
    virtual void    show(void) ;
//    virtual void    send_config(void) ; /* send config data to cloud */
//    virtual void    recv_config(void) ; /* receive config data from cloud */

/**
 * get_value sample sensor value and calcurate it to the metric value
 * @returns measured value in kgf/cm2
 */
    float get_value(void) ;

/**
 * Set threshold mode
 * @param mode int 0: absolute value 1: relative value in percent
 */
    void  set_thr_mode(int mode)    { _thr_mode = mode ; }

/**
 * Get threshold mode
 * @returns the mode 0: absolute value 1: relative value in percent
 */
    int   get_thr_mode(void)        { return _thr_mode ; }
    
/**
 * Set higher threshold
 * @param thr_high int16_t the higher threshold
 */
    void  set_thr_high(int16_t thr_high) ;
    
/**
 * Get higher threshold, the value is calcurated with expected value
 * @param expected float the expected pressure value for current temperature
 */
    float get_thr_high(float expected) ;
    
/**
 * Set lower threshold
 * @param thr_low int16_t the lower threshold
 */
    void  set_thr_low(int16_t thr_low) ;
    
/**
 * Get lower threshold, the value is calcurated with expected value
 * @param expected float the expected pressure value for current temperature
 */
    float get_thr_low(float expected)  ;
    
/**
 * draw triangle pointer for GAS pressure mode display
 */

    void drawPointer(int c) ;
    
private:
    PSE530  *_pse ;
    DigitalOut *_en ;
    float   _value ;
    float   _thr_high ;
    float   _thr_low ;
    int     _thr_mode ;
    float   _expected ;
    float   _higher ;
    float   _lower ;
} ;

float temp2expected(float temp) ;
extern float *current_temp ;

#endif /* _EDGE_PRESSURE_H_ */