#ifndef _EDGE_SENSOR_H_
#define _EDGE_SENSOR_H_
/**
 * edge_sensor super class of each sensor manager class
 */
#include "edge_time.h"
#include "afLib.h"
#include "af_mgr.h"
#include <ILI9341.h>
#include "edge_chart.h"

class edge_sensor {
public:
/**
 * constructor 
 */
    edge_sensor() ;

/**
 * destructor
 */
    ~edge_sensor() ;

/**
 * reset reset property valuse of edge_sensor
 */
    virtual void    reset(void) ;

/**
 * assign _id manually
 */
    virtual void    setId(uint16_t id) { _id = id ; }
    
    virtual uint16_t getId(void) { return _id ; } 
    
/**
 * enable the edge_sensor 
 */
    virtual void    enable(void) ;
    
/**
 * disable the edge_sensor
 */
    virtual void    disable(void) ;
    
/**
 * test if the edge_sensor is enabled (or not)
 * @returns true: the sensor is enabled false: the sensor is disabled
 */
    virtual bool    isEnabled(void) ;

/**
 * prepare the sensor for sampling
 */
    virtual void    prepare(void) ;
    
/**
 * sample trigger sampling action of the sensor and acquire the data
 * @returns 0:success non-0:failure
 */
    virtual int    sample(void) ;

    
/**
 * deliver the sampled data to the afero cloud via setAttributes
 */
    virtual int     deliver(void) ;
    
/**
 * show the value(s) to the display (TFT)
 */
    virtual void    show(void) ;
    
/**
 * toJson convert sampled data to json format
 * @param buf char* string buf to store the json string
 */
    virtual void    toJson(char *buf) ;
    
/**
 * display timestamp in human readable format
 * @parm ts int32_t timestamp value to display
 */
    virtual void    displayTime(int32_t ts) ;

/**
 * setInterval assign sampling interval time (in sec)
 * @param interval uint16_t the value to assign
 */
    void            setInterval(uint16_t interval) ;
    
/**
 * getInterval get sampling interval time (in sec)
 * @returns the interval time in uint16_t
 */
    uint16_t        getInterval(void) ;
    
/**
 * getStatus get current status of the state machine
 * @returns current status as int
 */
    int             getStatus(void) ;
    
/**
 * advanceStatus proceed status into the next state
 * @returns advanced status
 */
    int             advanceStatus(void) ;

/**
 * runStateMachine run the statemachine for single cycle
 * @returns the result status
 */
    virtual int     runStateMachine(void) ;
protected:
    uint16_t        _id ;
    bool            _enable ;
    uint32_t        _interval ;
    int             _status ;
    int             _error_count ;
    int             _sample_error ;
    int             _prev_status ;
    uint32_t        _end_interval ;
    uint32_t        _sampled_time ;
    char            _str_buf[256] ;
} ;

/* may be, we had better use enum here */
#define EDGE_SENSOR_INACTIVE    0
#define EDGE_SENSOR_WAIT        1
#define EDGE_SENSOR_READY       2
#define EDGE_SENSOR_PREPARED    3
#define EDGE_SENSOR_SAMPLED     4
#define EDGE_SENSOR_DELIVERED   5
#define EDGE_SENSOR_DISPLAYED   6

/* Y position of SUMMARY MODE */
#define EDGE_SUMMARY_X          10
#define EDGE_SUMMARY_TIME_Y     10
#define EDGE_SUMMARY_ACCEL_Y    45
#define EDGE_SUMMARY_PRESS_Y    80
#define EDGE_SUMMARY_COLOR1_Y   115
#define EDGE_SUMMARY_COLOR2_Y   150
#define EDGE_SUMMARY_TEMP_Y     185

#define EDGE_SAMPLE_SUCCESS     0
#define SAMPLE_ERROR_TOLERANCE  3

extern ILI9341             *display     ;
extern int                 display_mode ;
extern const unsigned char Arial12x12[] ;
extern const unsigned char Arial24x23[] ;
extern const unsigned char Arial28x28[] ;

#endif /* _EDGE_SENSOR_H_ */