#include "mbed.h"
#include "MQ4.h"

Serial pc(USBTX, USBRX); // tx, rx
MQ4 mq4(p18);                                                                    // Analog Port to read from

int main() {
    pc.baud(9600);
    mq4.begin();                                                                // 'Calibrate' sensor
    MQ4_data_t MQ4_data;                                                        // Structure to hold data.
    pc.printf("Ro calculated: %f\r\n",mq4.get_Ro()); 
    while (true) {
        pc.printf("H2 PPM: %.0f\r\n",mq4.readH2());                             // Performs a one shot read of CO
        pc.printf("CH4 PPM: %.0f\r\n",mq4.readCH4());                       // Performs a one shot read of Smoke
        pc.printf("LPG PPM: %.0f\r\n",mq4.readLPG());                           // Performs a one shot read of LPG
        wait(1);
        pc.printf("................................\r\n");                      
        mq4.read(&MQ4_data);                                                    // Alt reading method, reading to struct
        pc.printf("CO PPM: %.0f\r\n",MQ4_data.h2);                              // Return data from strut
        pc.printf("Smoke PPM: %.0f\r\n",MQ4_data.ch4);                        // Return data from strut
        pc.printf("LPG PPM: %.0f\r\n",MQ4_data.lpg);                            // Return data from strut
        pc.printf("................................\r\n");                      
        wait(1);
    }
}

