#include "mbed.h"
#include "L3GD20.h"
#include "LSM303D.h"
#include "LPS25H.h"

I2C i2c(p28,p27);

L3GD20 gyro(p28, p27);
LSM303D lsm(p28, p27);
LPS25H baro(i2c, LPS25H_V_CHIP_ADDR);

Serial pc(USBTX,USBRX);


int main(){
  
  float g[3];
  float acc[3] ,mag[3];
  pc.baud(9600);

  while (1){

    //Gyroscope
    gyro.read(&g[0],&g[1],&g[2]);
    pc.printf("Gyro-> X:%f Y:%f Z:%f\n",g[0] ,g[1] ,g[2]);
    //Acell/Mag
    if (lsm.read(&acc[0],&acc[1],&acc[2],&mag[0],&mag[1],&mag[2]))
    {
      pc.printf("Acc-> X:%.3f Y%.3f Z%.3f\nMag-> X%3f Y%3f Z%3f)\n",acc[0],acc[1],acc[2],mag[0],mag[1],mag[2]);
    }
    //Barometer
    baro.get();
    pc.printf("Pres:%6.1fpa\nTemp: %4.1fc\n", baro.pressure(), baro.temperature());      
    wait(0.5);
    }
}