#include <mbed.h>
#include <cmsis_os.h>
#include <stdint.h>
#include <limits.h>

#define NUM_THREADS 6

PwmOut red(LED1);
PwmOut green(LED2);
PwmOut blue(LED3);

void Timer1_Callback (void const *arg) {
    red = red + 0.01;                            // update the counter
    if(red == 1.){
        red = 0.0;
    }
}

void Timer2_Callback (void const *arg) {
    blue = blue + 0.15;                            // update the counter
    if(blue == 1.){
        blue = 0.0;
    }
}

osTimerDef (timer1, Timer1_Callback);
osTimerDef (timer2, Timer2_Callback);

int main (void) {
    osTimerId id1;
    osTimerId id2;

    green = 0;
    id1 = osTimerCreate (osTimer(timer1), osTimerPeriodic, NULL);
    osTimerStart (id1, 100UL);
    id2 = osTimerCreate (osTimer(timer2), osTimerPeriodic, NULL);
    osTimerStart (id2, 157UL);
    green = 1;
}
