/**
 ******************************************************************************
 * @file    main.cpp
 * @date    February 06, 2020
 * @brief   mbed test application - Esmacat Shield(EASE) working together with 
 *          Base Board with Arduino UNO form factor as EtherCAT slave.
 *          With the successful execution of this code the LED on EASE should
 *          blink. It should also estabilish data transfer between the EtherCAT
 *          Master of Esmacat on the PC.
 *          For further information please refer to the tutorials at
 *          https://www.esmacat.com/tutorials 
 ******************************************************************************
 
  Copyright (c) 2020 https://www.esmacat.com/

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  EsmacatShield.h - Library for using EtherCAT Arduino Shield by Esmacat(EASE).
  Created by Esmacat, 01/22/2020
  
*******************************************************************************
* @file EsmacatShield.h
*******************************************************************************
  LIVSMED
  @brief    마스터 로봇 조종기로부터 7개의 절대 엔코더의 값을 SSI통신으로 읽는다.
            4개의 입력이 있는 풋 페달장치로부터 입력 값을 받는다.
            총 8가지의 정보(7개의 엔코더 값 + 선택된 1개의 풋 페달값)를 EtherCAT IC
            로 전달한다.

*******************************************************************************

*/
#include "mbed.h"
#include <EsmacatShield.h> //Include EsmacatShield Library
#include "keypad.h"

int counter;
int16_t v[8];              //an array of integer is declared for reading the 
                           //data packet of EtherCAT from EASE 8 registers
BufferedSerial pc(USBTX, USBRX);   // Configuring the serial port to host PC
Ticker tick1;



SPI spi(D11, D12, D13);             // Infineon <->ARM mosi, miso, sclk
SPI spi2(PB_15, PB_14, PB_13);      // Encoder <->ARM mosi, miso, sclk
SPI spi3(PC_12, PC_11, PC_10);      // Encoder <->ARM mosi, miso, sclk

DigitalOut selectPin(D10);          // D10 is used to drive chip enable low

DigitalOut CS1(PA_10);               // Encoder CS
DigitalOut CS2(PA_8);
DigitalOut CS3(PA_9);
DigitalOut CS4(PC_7);
DigitalOut CS5(PB_8);
DigitalOut CS6(PC_1);
DigitalOut CS7(PC_0); 

DigitalOut greenLED(PB_0);                               
//////////////////////////



//////////////////////////
uint8_t  Hbyte_enc1 = 0;
uint8_t  Lbyte_enc1 = 0;
uint8_t  Hbyte_enc2 = 0;
uint8_t  Lbyte_enc2 = 0;
uint8_t  Hbyte_enc3 = 0;
uint8_t  Lbyte_enc3 = 0;
uint8_t  Hbyte_enc4 = 0;
uint8_t  Lbyte_enc4 = 0;
uint8_t  Hbyte_enc5 = 0;
uint8_t  Lbyte_enc5 = 0;
uint8_t  Hbyte_enc6 = 0;
uint8_t  Lbyte_enc6 = 0;
uint8_t  Hbyte_enc7 = 0;
uint8_t  Lbyte_enc7 = 0;

uint16_t Angle_encoder1 = 0;
uint16_t Angle_encoder2 = 0;
uint16_t Angle_encoder3 = 0;
uint16_t Angle_encoder4 = 0;
uint16_t Angle_encoder5 = 0;
uint16_t Angle_encoder6 = 0;
uint16_t Angle_encoder7 = 0;

uint32_t presentT = 0;
uint32_t previousT = 0;
uint32_t DeltaT = 0;

uint8_t TxdataBuffer[20];
uint8_t KeypadBuffer[4];
uint8_t keydata = 0;
uint32_t keypush = 0;
uint32_t pre_keypush = 0;
uint8_t keystate = 0;
uint8_t pushIndex = 0;
uint16_t Keypad_data = 0;

uint16_t TestData = 0;
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
void SetSSI(SPI&spi)
{
  spi.format(8, 1);
  spi.frequency(500000); //500 kHz    
}


void ReadEncoder(SPI&spi, uint8_t &low, uint8_t &high, DigitalOut& CS, uint16_t &angle)
{
  CS = 0;
  high = spi.write(0x00);
  low = spi.write(0x00);
  CS = 1;

  uint16_t Data = ((uint16_t)high << 2) + ((uint16_t)low >>6); 
  high = Data >> 8;
  low = Data & 0xff;
  
  angle = Data;
  //angle = (float)Data * (360.0 / 1024.0);
  //angle = (uint16_t)(angle * 1000);
}


 
//////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////////
int main() 
{

    EsmacatShield slave(spi, selectPin);  //Create an Esmacat slave object with defined
                                          // spi and chip SelectPin
    slave.setup_spi();                    //Setup SPI for EASE
    
    SetSSI(spi2); 
    SetSSI(spi3); 
    
    greenLED = 0;
    //tick1.attach(MeasureEncoder, 0.01);
    
    Keypad keypad(PC_3, PC_2, NC, NC, PA_14, PA_13, NC, NC);
    keypad.enablePullUp();
    char key;
    
    
    while(1)
    {
      TestData++;
      if(TestData == 5) {
        TestData = 0;
       greenLED = !greenLED;   
      }
      
      key = keypad.getKey();
      if(key != KEY_RELEASED)
      {
          keydata = key;
          
          if(keydata == '1'){KeypadBuffer[1]= 0xC1;}
          else if(keydata == '4'){KeypadBuffer[1]=0xC2;}
          else if(keydata == '2'){KeypadBuffer[1]=0xC3;}
          else if(keydata == '5'){keypush++;} 
        
      }
      
      if (keypush == pre_keypush){
         keypush = 0;    
      }
      
      if((keypush > 2)&&(keystate == 0x00)){
         KeypadBuffer[2] = 0x00;
         keystate = 0x00;
         pushIndex = 1;   
      }
      else if((keypush > 2)&&(keystate == 0x01)){
         KeypadBuffer[2] = 0x01;
         keystate = 0x01;
         pushIndex = 1;     
      }
      else if ((keypush == 0)&&(keystate == 0x00)){
         if(pushIndex == 0){
            KeypadBuffer[2] = 0x00;
            keystate = 0x00;
         }
         if(pushIndex == 1){
            KeypadBuffer[2] = 0x01;
            keystate = 0x01;
            pushIndex = 0;
         }    
      }
      else if ((keypush == 0)&&(keystate == 0x01)){
         if(pushIndex == 0){
            KeypadBuffer[2] = 0x01;
            keystate = 0x01;
         }
         if(pushIndex == 1){
            KeypadBuffer[2] = 0x00;
            keystate = 0x00;
            pushIndex = 0;
         }    
      }
      
      pre_keypush = keypush;
      
      Keypad_data = (uint16_t)(KeypadBuffer[1] << 8) | KeypadBuffer[2];
      
      ReadEncoder(spi3, Lbyte_enc4, Hbyte_enc4, CS4, Angle_encoder4);
      ReadEncoder(spi3, Lbyte_enc5, Hbyte_enc5, CS5, Angle_encoder5);
      ReadEncoder(spi3, Lbyte_enc6, Hbyte_enc6, CS6, Angle_encoder6);      
      ReadEncoder(spi3, Lbyte_enc7, Hbyte_enc7, CS7, Angle_encoder7);
      ReadEncoder(spi2, Lbyte_enc1, Hbyte_enc1, CS1, Angle_encoder1);
      ReadEncoder(spi2, Lbyte_enc2, Hbyte_enc2, CS2, Angle_encoder2);
      ReadEncoder(spi2, Lbyte_enc3, Hbyte_enc3, CS3, Angle_encoder3);
      
      
      slave.write_reg_value(0,Angle_encoder1, true);
      slave.write_reg_value(1,Angle_encoder2, true);
      slave.write_reg_value(2,Angle_encoder3, true);
      slave.write_reg_value(3,Angle_encoder4, true);
      slave.write_reg_value(4,Angle_encoder5, true);
      slave.write_reg_value(5,Angle_encoder6, true);
      slave.write_reg_value(6,Angle_encoder7, true);
      slave.write_reg_value(7,Keypad_data, true);
      
      
      printf("ENC1: %d, ENC2: %d, ENC3: %d, ENC4: %d,ENC5: %d, ENC6: %d, ENC7: %d\n", Angle_encoder1, Angle_encoder2, Angle_encoder3, Angle_encoder4,Angle_encoder5, Angle_encoder6, Angle_encoder7);

      wait_us(100000);

    }

}
