/* Copyright (c) 2019 Analog Devices, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation 
  and/or other materials provided with the distribution.  
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors/products 
  manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner 
  that would cause the software to become subject to terms and conditions which 
  differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its contributors 
  may be used to endorse or promote products derived from this software without 
  specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one or 
  more patent holders.  This license does not release you from the requirement 
  that you obtain separate licenses from these patent holders to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT, 
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN 
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL 
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

2019-01-10-7CBSD SLA

 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "ADXL355.h"

/* Global Data */

float LSB_scale_factor=0.0000039f; 

int32_t volatile i32SensorX;
int32_t volatile i32SensorY;
int32_t volatile i32SensorZ;
int32_t volatile i32SensorT;

uint8_t volatile ui8SensorX;
uint8_t volatile ui8SensorX2;
uint8_t volatile ui8SensorX3;
uint32_t volatile ui32SensorX;

uint8_t volatile ui8SensorY;
uint8_t volatile ui8SensorY2;
uint8_t volatile ui8SensorY3;
uint32_t volatile ui32SensorY;

uint8_t volatile ui8SensorZ;
uint8_t volatile ui8SensorZ2;
uint8_t volatile ui8SensorZ3;
uint32_t volatile ui32SensorZ;


uint8_t volatile ui8SensorT;
uint8_t volatile ui8SensorT2;
uint32_t volatile ui32SensorT;

uint32_t volatile ui32Result = 0;

// Blinking rate in milliseconds
#define SLEEP_TIME                  500
// Setup the SPI peripheral to talk to the ADXL35x
//SPI spi(D11, D12, D13);
// initialize chip select
//DigitalOut cs(D10);

SPI spi(PB_15, PB_14, PB_13);
// initialize chip select
DigitalOut cs(PB_1);





// Initialise the digital pin LED1 as an output
DigitalOut led1(LED1);
// Initialise the serial object with TX and RX pins
Serial pc(USBTX, USBRX);
Timer t; 
int id=0;
int i=1;

// main() runs in its own thread in the OS
int main()
{
    pc.printf("Hello World!");
    pc.baud (115200) ;
    
    spi.frequency(1000000);
    
    cs=0;
    spi.write(DEVID_AD<<1|0x01);
    id=spi.write(0xFF);
    cs=1;
    pc.printf("ID register = 0x%X\n", id);
    // This should output the ID register as 0xAD
    
    cs=0;
    spi.write(DEVID_MST<<1|0x01);
    id=spi.write(0xFF);
    cs=1;
    pc.printf("DEVID register = 0x%X\n", id);
    // This should output the ID register as 0x1D
    
    cs=0;
    spi.write(PARTID<<1|0x01);
    id=spi.write(0xFF);
    cs=1;
    pc.printf("PARTID register = 0x%X\n", id);
    // This should output the ID register as 0xED
    
    cs=0;
    spi.write(REVID<<1|0x01);
    id=spi.write(0xFF);
    cs=1;
    pc.printf("REVID register = 0x%X\n", id);
    // This should output the ID register as 0x01

    // Turn on the sensor
    ADXL355_Start_Sensor();
    
    // Now dump the temp and accelerometer data to the port
    
    while (true) {
         t.start(); 
        
        // Blink LED and wait 500 ms
        //led1 = !led1;
        //thread_sleep_for(SLEEP_TIME);
        
        //the acceleration data is 20 bits and needs to come in via three register transactions
        cs=0;
        spi.write(XDATA3<<1|0x01);
        ui8SensorX=spi.write(0xFF); 
        ui8SensorX2=spi.write(0xFF);
        ui8SensorX3=spi.write(0xFF);        
        cs=1;
        // Put it back together
        
        ui32Result = ((ui8SensorX << 16) | (ui8SensorX2 << 8) | ui8SensorX3); /* Set read result*/
        //pc.printf("X acceleration data = 0x%X\n", ui32Result);
        // This should output the ID register as 0x01        
        i32SensorX = ADXL355_Acceleration_Data_Conversion(ui32Result); 
        //pc.printf("X acceleration formatted data = %d\n", i32SensorX);
     //  pc.printf("%2.6f   \n\r", i32SensorX*LSB_scale_factor);
        
        //the acceleration data is 20 bits and needs to come in via three register transactions
        cs=0;
        spi.write(YDATA3<<1|0x01);
        ui8SensorY=spi.write(0xFF); 
        ui8SensorY2=spi.write(0xFF);
        ui8SensorY3=spi.write(0xFF);        
        cs=1;
        // Put it back together
        
        ui32Result = ((ui8SensorY << 16) | (ui8SensorY2 << 8) | ui8SensorY3); /* Set read result*/
        //pc.printf("Y acceleration data = 0x%X\n", ui32Result);
        // This should output the ID register as 0x01        
        i32SensorY = ADXL355_Acceleration_Data_Conversion(ui32Result); 
        //pc.printf("Y acceleration formatted data = %d\n", i32SensorY);
     //  pc.printf("%2.6f   \n\r", i32SensorY*LSB_scale_factor);
        
        
        
        
        //the acceleration data is 20 bits and needs to come in via three register transactions
        cs=0;
        spi.write(ZDATA3<<1|0x01);
        ui8SensorZ=spi.write(0xFF); 
        ui8SensorZ2=spi.write(0xFF);
        ui8SensorZ3=spi.write(0xFF);        
        cs=1;
        // Put it back together
        
        
       
        
        
        ui32Result = ((ui8SensorZ << 16) | (ui8SensorZ2 << 8) | ui8SensorZ3); /* Set read result*/
        //pc.printf("Z acceleration data = 0x%X\n", ui32Result);
        // This should output the ID register as 0x01        
        i32SensorZ = ADXL355_Acceleration_Data_Conversion(ui32Result);        
        //pc.printf("Z acceleration formatted data = %d \n", i32SensorZ);
    //   pc.printf("%2.6f  \n\r", i32SensorZ*LSB_scale_factor);
        
        
        
        
            
        t.stop(); 
        //pc.printf(" %d us\n\r", t.read_us());  wait1.5ms

        wait(0.01); //max0.0016
        
         
        
    }
}
int32_t ADXL355_Acceleration_Data_Conversion (uint32_t ui32SensorData)
{
   int32_t volatile i32Conversion = 0;

   ui32SensorData = (ui32SensorData  >> 4);
   ui32SensorData = (ui32SensorData & 0x000FFFFF);

   if((ui32SensorData & 0x00080000)  == 0x00080000){

         i32Conversion = (ui32SensorData | 0xFFF00000);

   }
   else{
         i32Conversion = ui32SensorData;
   }

   return i32Conversion;
}

void ADXL355_Start_Sensor(void)
{
   cs=0;
   spi.write(POWER_CTL<<1|0x01);
   id=spi.write(0xFF);
   cs=1;
   pc.printf("POWER_CTL register = 0x%X\n", id);
    
   id = id & 0xFE; // Clear measurement bit in POWER_CTL register and turn it on
   
   // Write the power control register, which involves add a '1' to the 8th bit 
   // address for the ADXL355
   
   int volatile tmp=(POWER_CTL<<1);
   
   cs=0;
   spi.write(tmp);
   spi.write(id);
   cs=1;
      
   
   //SPI_Write(POWER_CTL, ui8temp, 0x00, SPI_WRITE_ONE_REG);                    /* Write the new value to POWER_CTL register */
}


