/***************************************************************************//**
 *   @file   Communication.c
 *   @brief  Implementation of Communication Driver.
 *   @author DBogdan (dragos.bogdan@analog.com)
********************************************************************************
 * Copyright 2012-2015(c) Analog Devices, Inc.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  - Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *  - Neither the name of Analog Devices, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *  - The use of this software may or may not infringe the patent rights
 *    of one or more patent holders.  This license does not release you
 *    from the requirement that you obtain separate licenses from these
 *    patent holders to use this software.
 *  - Use of the software either in source or binary form, must be run
 *    on or directly connected to an Analog Devices Inc. component.
 *
 * THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*******************************************************************************/

/******************************************************************************/
/* Include Files                                                              */
/******************************************************************************/
#include "Communication.h"
#include "stdlib.h"
#include "mbed.h"
/***************************************************************************//**
 * @brief Initializes the SPI communication peripheral.
 *
 * @param lsbFirst - Transfer format (0 or 1).
 *                   Example: 0x0 - MSB first.
 *                            0x1 - LSB first.
 * @param clockFreq - SPI clock frequency (Hz).
 *                    Example: 1000 - SPI clock frequency is 1 kHz.
 * @param clockPol - SPI clock polarity (0 or 1).
 *                   Example: 0x0 - Idle state for clock is a low level; active
 *                                  state is a high level;
 *                        0x1 - Idle state for clock is a high level; active
 *                                  state is a low level.
 * @param clockEdg - SPI clock edge (0 or 1).
 *                   Example: 0x0 - Serial output data changes on transition
 *                                  from idle clock state to active clock state;
 *                            0x1 - Serial output data changes on transition
 *                                  from active clock state to idle clock state.
 *
 * @return status - Result of the initialization procedure.
 *                  Example: 1 - if initialization was successful;
 *                           0 - if initialization was unsuccessful.
*******************************************************************************/
#define PRINT_SPI_INFO


unsigned char read_buff[AD7190_READ_BUFFER_SIZE];


unsigned char SPI_Init(unsigned char lsbFirst,
                       unsigned long clockFreq,
                       unsigned char clockPol,
                       unsigned char clockEdg)
{
    /* Add your code here. */
    spi.format(8,3);
    spi.frequency(clockFreq);
    memset(read_buff, 0, AD7190_READ_BUFFER_SIZE);
    return 1;
}

/***************************************************************************//**
 * @brief Reads data from SPI.
 *
 * @param data - Data represents the write buffer as an input parameter and the
 *               read buffer as an output parameter.
 * @param bytesNumber - Number of bytes to read.
 *
 * @return Number of read bytes.
*******************************************************************************/
unsigned char SPI_Read(unsigned char* data,
                       unsigned char bytesNumber)
{
    /* Add your code here. */
    int r_cnt = 0;

    if(bytesNumber > AD7190_READ_BUFFER_SIZE) return 0;

    #ifdef PRINT_SPI_INFO
 //       pc.printf("[SPI-OTR] 0x%02x\r\n", data[0]);
    #endif

    data[r_cnt] = spi.write(data[0]);
    bytesNumber --;
    r_cnt++;

    #ifdef PRINT_SPI_INFO
  //      pc.printf("[SPI-IN ] ");
    #endif
    while(bytesNumber > 0){
        data[r_cnt] = spi.write(0xFF);
       
        #ifdef PRINT_SPI_INFO
   //         pc.printf("0x%02x\t", data[r_cnt]);
        #endif

        r_cnt++;
        bytesNumber --;
    }

    #ifdef PRINT_SPI_INFO
    //    pc.printf("\r\n");
    #endif
    
    return r_cnt;
}

/***************************************************************************//**
 * @brief Writes data to SPI.
 *
 * @param data - Data represents the write buffer.
 * @param bytesNumber - Number of bytes to write.
 *
 * @return Number of written bytes.
*******************************************************************************/
unsigned char SPI_Write(unsigned char* data,
                        unsigned char bytesNumber)
{
    /* Add your code here. */
    memset(read_buff, 0, AD7190_READ_BUFFER_SIZE);
    int w_cnt = 0;

    if(bytesNumber > AD7190_READ_BUFFER_SIZE) return 0;
    
    #ifdef PRINT_SPI_INFO
  //      pc.printf("[SPI-OUT] ");
    #endif

    while(bytesNumber > 0){
        read_buff[w_cnt] = spi.write(data[w_cnt]);

        #ifdef PRINT_SPI_INFO
  //          pc.printf("0x%02x\t", data[w_cnt]);
        #endif
        
        w_cnt++;
        bytesNumber --;
    }

    #ifdef PRINT_SPI_INFO
  //      pc.printf("\r\n[SPI-RTN] ");
        for(int i=0; i<w_cnt; i++){
   //         pc.printf("0x%02x\t", read_buff[w_cnt]);
        }
   //     pc.printf("\r\n");
    #endif
    
    return  w_cnt;
}
