#include "text.h"
#include "mbed.h"
#include "letters.h"

text::text(): pc(USBTX, USBRX), local("local"){
};

void text::generate(string input){
    stringLength = input.length();
    if (stringLength == 0) return;
    pc.printf("\r\nStarting generation, string length: %i", stringLength);
    fp = fopen("/local/out.txt", "w");
    pc.printf("\r\nOpened a text file out.txt");
    calcLength(input);
    fprintf(fp, "%i\r\n", length);
    for (int i = 0; i < 16; i++){
        fprintf(fp, "%02x\r\n", 0x00);
    }
    for (int i = 0; i < stringLength; i++){
        pc.printf("\r\nTaking letter ");
        pc.putc(input.at(i));
        letters(input.at(i));
        pc.printf("\r\nDone with ");
        pc.putc(input.at(i));
        tempCheck();
        for (int j = 7; j >= (8 - letSize); j--){
            uint8_t hex = 0;
            for (int g = 7; g >= 0; g--){ 
                //fprintf(fp, "%i", ((temp[g] & (1 << j)) >> j));
                hex |= (((temp[g] & (1 << j)) >> j) << g);
            }
            fprintf(fp,"%02x\r\n", hex);
        } 
        fprintf(fp, "%02x\r\n", 0x00);    
    } 
    for (int i = 0; i < 15; i++){
        fprintf(fp, "%02x\r\n", 0x00);
    }
    pc.printf("\r\n%02x", 0x3e);
    fprintf(fp, "%02x\r\n", 0x3e);
    fclose(fp);   
}

void text::letters(char take){
    
    switch (take){
        case 'A': 
            letSize = 4;
            memcpy(temp, letterA, sizeof(letterA));
            break;
        case 'B':
            letSize = 4;
            memcpy(temp, letterB, sizeof(letterB));
            break;
        case 'C':
            letSize = 4;
            memcpy(temp, letterC, sizeof(letterC));
            break;
        case 'D':
            letSize = 4;
            memcpy(temp, letterD, sizeof(letterD));
            break;
        case 'E':
            letSize = 4;
            memcpy(temp, letterE, sizeof(letterE));
            break;
        case 'F':
            letSize = 4;
            memcpy(temp, letterF, sizeof(letterF));
            break;
        case 'G':
            letSize = 4;
            memcpy(temp, letterG, sizeof(letterG));
            break;
        case 'H':
            letSize = 4;
            memcpy(temp, letterH, sizeof(letterH));
            break;
        case 'I':
            letSize = 1;
            memcpy(temp, letterI, sizeof(letterI));
            break;
        case 'J':
            letSize = 3;
            memcpy(temp, letterJ, sizeof(letterJ));
            break;
        case 'K':
            letSize = 4;
            memcpy(temp, letterK, sizeof(letterK));
            break;
        case 'L':
            letSize = 4;
            memcpy(temp, letterL, sizeof(letterL));
            break;
        case 'M':
            letSize = 5;
            memcpy(temp, letterM, sizeof(letterM));
            break;
        case 'N':
            letSize = 4;
            memcpy(temp, letterN, sizeof(letterN));
            break;
        case 'O':
            letSize = 4;
            memcpy(temp, letterO, sizeof(letterO));
            break;
        case 'P':
            letSize = 4;
            memcpy(temp, letterP, sizeof(letterP));
            break;
        case 'Q':
            letSize = 5;
            memcpy(temp, letterQ, sizeof(letterQ));
            break;
        case 'R':
            letSize = 4;
            memcpy(temp, letterR, sizeof(letterR));
            break;
        case 'S':
            letSize = 4;
            memcpy(temp, letterS, sizeof(letterS));
            break;
        case 'T':
            letSize = 5;
            memcpy(temp, letterT, sizeof(letterT));
            break;
        case 'U':
            letSize = 4;
            memcpy(temp, letterU, sizeof(letterU));
            break;
        case 'V':
            letSize = 5;
            memcpy(temp, letterV, sizeof(letterV));
            break;
        case 'W':
            letSize = 5;
            memcpy(temp, letterW, sizeof(letterW));
            break;
        case 'X':
            letSize = 5;
            memcpy(temp, letterX, sizeof(letterX));
            break;
        case 'Y':
            letSize = 5;
            memcpy(temp, letterY, sizeof(letterY));
            break;
        case 'Z':
            letSize = 4;
            memcpy(temp, letterZ, sizeof(letterZ));
            break;
        case 'a': 
            letSize = 4;
            memcpy(temp, lettera, sizeof(lettera));
            break;
        case 'b':
            letSize = 4;
            memcpy(temp, letterb, sizeof(letterb));
            break;
        case 'c':
            letSize = 4;
            memcpy(temp, letterc, sizeof(letterc));
            break;
        case 'd':
            letSize = 4;
            memcpy(temp, letterd, sizeof(letterd));
            break;
        case 'e':
            letSize = 4;
            memcpy(temp, lettere, sizeof(lettere));
            break;
        case 'f':
            letSize = 4;
            memcpy(temp, letterf, sizeof(letterf));
            break;
        case 'g':
            letSize = 4;
            memcpy(temp, letterg, sizeof(letterg));
            break;
        case 'h':
            letSize = 4;
            memcpy(temp, letterh, sizeof(letterh));
            break;
        case 'i':
            letSize = 1;
            memcpy(temp, letteri, sizeof(letteri));
            break;
        case 'j':
            letSize = 3;
            memcpy(temp, letterj, sizeof(letterj));
            break;
        case 'k':
            letSize = 4;
            memcpy(temp, letterk, sizeof(letterk));
            break;
        case 'l':
            letSize = 1;
            memcpy(temp, letterl, sizeof(letterl));
            break;
        case 'm':
            letSize = 5;
            memcpy(temp, letterm, sizeof(letterm));
            break;
        case 'n':
            letSize = 4;
            memcpy(temp, lettern, sizeof(lettern));
            break;
        case 'o':
            letSize = 4;
            memcpy(temp, lettero, sizeof(lettero));
            break;
        case 'p':
            letSize = 4;
            memcpy(temp, letterp, sizeof(letterp));
            break;
        case 'q':
            letSize = 4;
            memcpy(temp, letterq, sizeof(letterq));
            break;
        case 'r':
            letSize = 4;
            memcpy(temp, letterr, sizeof(letterr));
            break;
        case 's':
            letSize = 4;
            memcpy(temp, letter_s, sizeof(letter_s));
            break;
        case 't':
            letSize = 4;
            memcpy(temp, lettert, sizeof(lettert));
            break;
        case 'u':
            letSize = 4;
            memcpy(temp, letteru, sizeof(letteru));
            break;
        case 'v':
            letSize = 5;
            memcpy(temp, letterv, sizeof(letterv));
            break;
        case 'w':
            letSize = 5;
            memcpy(temp, letterw, sizeof(letterw));
            break;
        case 'x':
            letSize = 4;
            memcpy(temp, letterx, sizeof(letterx));
            break;
        case 'y':
            letSize = 4;
            memcpy(temp, lettery, sizeof(lettery));
            break;
        case 'z':
            letSize = 4;
            memcpy(temp, letterz, sizeof(letterz));
            break;
        case ' ':
            letSize = 3;
            memcpy(temp, letterGap, sizeof(letterGap));
            break;
        default :
            letSize = 1;
            memcpy(temp, letterDef, sizeof(letterDef));
    }
}    

void text::tempCheck(){
    pc.printf("\r\n");
    for (int i = 0; i < 8; i++){
        pc.printf("0x%02x ", temp[i]);
    }
    pc.printf("\r\n");
}

void text::calcLength(string input){
    length = 0;
    for (int i = 0; i < stringLength; i++){
        letters(input.at(i));
        length += letSize + 1;
    }   
    length += 31;  
}