#ifndef MBED_MATRIX_H_
#define MBED_MATRIX_H_

#include "mbed.h"

void led_thread(void const *args);

class matrix{
private:
    int length;
    int display[8][16];
    Serial pc;
    LocalFileSystem local;
    FILE *fp; 
    DigitalOut in3;
    DigitalOut in2;
    DigitalOut in1;
    DigitalOut clr1;
    DigitalOut clr;
    DigitalOut clk1;
    DigitalOut clk;   
public:
    matrix(PinName _in1, PinName _in2, PinName _in3, PinName _clr, PinName _clr1, PinName _clk, PinName _clk1);
    void show();
    void clear();
    void multiplex();
    void clock(char *buffer, bool dot);
    void see();
};    

#endif /* matrix_H_ */