#include "mbed.h"
#include "matrix.h"
#include "text.h"
#include <string>

text generator;
matrix display(p13, p12, p11, p14, p15, p17, p16);
DigitalOut led(LED1);
Serial pc(USBTX, USBRX);
Serial bluetooth(p28,p27);
char line[99];
char line_buffer[99];
volatile bool mode_buffer = 0;
volatile uint8_t interrupt_flag = 0;
volatile int realTime;
void receive();

int main() {
    bool m_mode = 0;
    char buffer[4];
    bool dot;
    pc.baud(115200);
    bluetooth.baud(115200);
    void (*foo)() = &receive;
    bluetooth.attach(foo, Serial::RxIrq);
    generator.generate("Hello world!");
    while(true){
        if (interrupt_flag == 1){
            pc.printf("\r\nIn interrupt flag!");
            m_mode = mode_buffer;
            memcpy(line, line_buffer, sizeof(line_buffer));
            memset(line_buffer, 0, sizeof(line_buffer));
            interrupt_flag = 0;
        }
        pc.printf("\r\nMode = %i", m_mode);
        if (strlen(line) > 0 && m_mode == 0 && interrupt_flag == 0){  
            led = 0;  
            generator.generate(line);
            memset(line, 0, sizeof(line));
        }
        else if (strlen(line) > 0 && m_mode == 1 && interrupt_flag == 0){
            led = 0;
            memset(line, 0, sizeof(line));
        }
        if(m_mode == 1 && interrupt_flag == 0){
            time_t seconds = time(NULL);
            strftime(buffer, 4, "%H%M", localtime(&seconds)); 
            if ((seconds % 2) == 0) dot = true;
            else dot = false; 
            display.clock(buffer, dot);
        }
        else if (interrupt_flag == 0) display.show();
        //wait(0.1);
    }
}

void receive(){
    led = 1;
    int i, j = 0;
    i = 10 * (bluetooth.getc() - 48);
    i += bluetooth.getc() - 48;
    if(i > 0){
        mode_buffer = false;
        do{ 
            line_buffer[j] = bluetooth.getc();
            j++;
            wait(0.0001);       
        }
        while(bluetooth.readable() && (j < i) && (j < 99));
    }
    else{
        mode_buffer = true;
        for (int i = 0; i < 10; i++){                   
            line_buffer[i] = bluetooth.getc();
            wait(0.0001);
        }
        realTime = atoi(line_buffer);
        set_time(realTime);
    }  
    while (bluetooth.readable()){
            bluetooth.getc();
    }
    interrupt_flag = 1; 
}