#include "matrix.h"
#include "numbers.h"

matrix::matrix(PinName _in1, PinName _in2, PinName _in3, PinName _clr, 
PinName _clr1, PinName _clk, PinName _clk1): local("local"), in1(_in1), in2(_in2), 
in3(_in3), clr(_clr), clr1(_clr1), clk(_clk), clk1(_clk1), pc(USBTX, USBRX){
};

void matrix::show(){
    uint8_t temp;
    fp = fopen("/local/out.txt", "r");
    fscanf(fp, "%i", &length);
    pc.printf("\r\nLength = %i", length);
    for (int i = 0; i < 16; i++){
        fscanf(fp, "%x", &temp);
        //pc.printf("\r\n%02x", temp);
        for (int j = 0; j < 8; j++){
            display[7 - j][i] = ((temp & (1 << (7 - j))) >> j);    
        }
    }
    for (int i = 15; i < length; i++){
        for (int j = 0; j < 8; j++){
            multiplex();
        }
        for (int g = 0; g < 15; g++){
            for (int h = 0; h < 8; h++){
                display[h][g] = display[h][g + 1];
            }
        }
        fscanf(fp, "%x", &temp);
        //pc.printf("\r\n%02x", temp);
        for (int j = 0; j < 8; j++){
            display[j][15] = ((temp & (1 << j)) >> j);
        }
    }    
    fclose(fp);
}

void matrix::clear(){
    in1 = 1;
    in2 = 0;
    in3 = 0;
    clk = 0;
    clk1 = 0;
    clr = 0;
    clr1 = 0;
    clr = 1;
    clr1 = 1;
}

void matrix::multiplex(){
    int a[8] = {0, 1, 1, 1, 1, 1, 1, 1};
    clear();
    for (int i = 0; i < 8; i++){
        clear();
        for (int g = 0; g < 8; g++){
            in1 = a[g];
            //pc.printf("%i", a[g]);
            clk = 1;
            //wait(del);
            clk = 0;
            //wait(del);    
        }
        //pc.printf("\r\n");
        for (int j = 7; j > (-1); j--){
            in3 = display[i][j];
            in2 = display[i][j + 8];
            //pc.printf("%i", show[i][j]);
            clk1 = 1;
            //wait(del);
            clk1 = 0;
            //wait(del);      
        }
        wait(0.001);
        //pc.printf("\r\n");
        a[i] = 1;
        a[i + 1] = 0;
    }    
}

void matrix::clock(char *buffer, bool dot){
    //pc.printf("\r\nClock %s", buffer);
    
    memset(display, 0, sizeof(display));
    
    int digit = int(buffer[0]) - 48;
    //pc.printf("\r\nDigit= %i", digit);
    
    for (int i = 0; i < 3; i++){
        for (int j = 0; j < 8; j++){
            display[j][i] = ((number[i][digit] & (1 << (7 - j))) >> (7 - j));
        };       
    };  
    
    digit = int(buffer[1]) - 48;
    //pc.printf("\r\nDigit= %i", digit);
    
    for (int i = 4; i < 7; i++){
        for (int j = 0; j < 8; j++){
            display[j][i] = ((number[i - 4][digit] & (1 << (7 - j))) >> (7 - j));
        };       
    }; 
    
    digit = int(buffer[2]) - 48;
    //pc.printf("\r\nDigit= %i", digit);
    
    for (int i = 9; i < 12; i++){
        for (int j = 0; j < 8; j++){
            display[j][i] = ((number[i - 9][digit] & (1 << (7 - j))) >> (7 - j));
        };       
    }; 
    
    digit = int(buffer[3]) - 48;
    //pc.printf("\r\nDigit= %i", digit);
    
    for (int i = 13; i < 16; i++){
        for (int j = 0; j < 8; j++){
            display[j][i] = ((number[i - 13][digit] & (1 << (7 - j))) >> (7 - j));
        };       
    }; 
    
    if (dot) display[6][7] = 1;
    //see();
    for (int i = 0; i < 10; i++) multiplex();
    //while (!pc.getc());
};

void matrix::see(){
    pc.printf("\r\n");
    for (int i = 0; i < 8; i++){
        for (int j = 0; j < 16 ; j++){
            pc.printf("%i ", display[i][j]);
        }
        pc.printf("\r\n");
    }
    pc.printf("\r\n");
}
