#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Serial pc (USBTX,USBRX);
Serial target (p28,p27);

// We'll drive this low, and then set the as inputs
// this mimics an open collector style ouput
DigitalInOut reset (p29);
DigitalInOut isp   (p30);

int main() {

    pc.baud(115200);
    target.baud(115200);
   
    // ISP Input with pullup
    pc.printf("Ready!\r\n");
    isp.input();
    isp.mode(PullUp);

    // pulse reset low
    reset.output();
    reset = 0;
    wait (0.01);
    
    // reset input, with pullup
    reset.input();
    reset.mode(PullUp);
    
    while (!pc.readable()) {}   
   
    // pull ISP and nReset low
    reset.output();
    isp.output();
    reset = 0;
    isp = 0;
    
    wait (0.1);
    
    // Bring target out of reset
    reset.input();
    reset.mode(PullUp);
    
    wait (0.1);

    while (1) {
    
        if (pc.readable()) {
            target.putc(pc.getc());
            led1 = !led1;
        }
    
        if (target.readable()) {
            pc.putc(target.getc());
            led2 = !led2;
        }
    
    }
}