#include "mbed.h"
#include <string>

Serial pc(USBTX, USBRX);
Serial wifi(p28,p27);
Timer t;

DigitalOut myled(LED1);

int initializeWifi();

void serverResponse();

int main() {
    pc.baud(115200);
    wifi.baud(115200);
    pc.printf("Ready to boil!\r\n");
    initializeWifi();
    
    char buffer[50];
    int bufferIndex = 0;
    
    while(1) {
        
        if(pc.readable()){
            wifi.putc(pc.getc());
        }
        
        if(wifi.readable()){
            char c = wifi.getc();
            pc.putc(c);
            if (c != 10){ 
                buffer[bufferIndex] = c;
                bufferIndex++;
            }
            else{
                if(strstr(buffer, "Alive") != NULL){
                    pc.printf("Yayy\r\n");
                    serverResponse();//Do the response
                }
                memset(buffer, 0, 50);
                bufferIndex = 0;
            } 
        } 
    }
}

int initializeWifi(){
    t.reset();
    t.start();
    wifi.printf("AT+RST\r\n"); 
    while(t.read() < 0.2){ 
        while(wifi.readable()) pc.putc(wifi.getc());
    }
    t.stop();
    wifi.printf("AT+CWJAP=\"Liutauras WiFi\",\"12345678\"\r\n");
    t.reset();
    t.start();
    while(t.read() < 7){
        while(wifi.readable()) pc.putc(wifi.getc());  
    } 
    t.stop();
    t.reset();
    wifi.printf("AT+CIFSR\r\n");
    t.start();
    while(t.read() < 0.2){
        while(wifi.readable()) pc.putc(wifi.getc());  
    }
     
    t.stop();
    t.reset();
    wifi.printf("AT+CIPMUX=1\r\n");
    t.start();
    while(t.read() < 0.2){
        while(wifi.readable()) pc.putc(wifi.getc());  
    } 
    
    t.stop();
    t.reset();
    wifi.printf("AT+CIPSERVER=1,80\r\n");
    t.start();
    while(t.read() < 0.2){
        while(wifi.readable()) pc.putc(wifi.getc());  
    }
    return true;  
}

void serverResponse(){
    string temp1 = "HTTP/1.1 200 OK\r\n";
    string temp2 = "Server: SuperBoiler\r\n";
    string temp3 = "Content-Type: application/json\r\n";
    string temp4 = "Connection: Closed\r\n";
    string temp5 = "\"message\":\"BoilMe\"";
    
    wifi.printf("AT+CIPSEND=0,%d\r\n", sizeof(temp1)+sizeof(temp2)+sizeof(temp3)+sizeof(temp4)+sizeof(temp5));
    t.reset();
    t.start();
    while(t.read() < 4){
        while(wifi.readable()) pc.putc(wifi.getc());  
    }  
    t.stop();
    pc.printf("%s", temp1);
    pc.printf("%s", temp2);
    pc.printf("%s", temp3);
    pc.printf("%s", temp4);
    pc.printf("%s", temp5);
    wifi.printf("%s", temp1);
    wifi.printf("%s", temp2);
    wifi.printf("%s", temp3);
    wifi.printf("%s", temp4);
    wifi.printf("%s", temp5);
    
    //wifi.printf("HTTP/1.1 200 OK\r\n");
    //wifi.printf("Server: SuperBoiler\r\n");
    //wifi.printf("Content-Length: 88\r\n");
    //wifi.printf("Content-Type: application/json\r\n");
    //wifi.printf("Connection: Closed\r\n");
    //wifi.printf("\"message\":\"BoilMe\"");          
}
