

#include <mbed.h>

#include "nRF24L01.h"
#include "RF24.h"




//
// Hardware configuration
//




/*


    _____
    |8|7|     pi map with oscillator up front
    -----
    |6|5|
    -----
    |4|3|
    -----
    |2|1|
    -----
  PINOUTS
  http://docs.spark.io/#/firmware/communication-spi
  http://maniacbug.wordpress.com/2011/11/02/getting-started-rf24/

  SPARK CORE    SHIELD SHIELD    NRF24L01+
  GND           GND              1 (GND)
  3V3 (3.3V)    3.3V             2 (3V3)
  D6 (CSN)      9  (D6)          3 (CE)
  A2 (SS)       10 (SS)          4 (CSN)
  A3 (SCK)      13 (SCK)         5 (SCK)
  A5 (MOSI)     11 (MOSI)        6 (MOSI)
  A4 (MISO)     12 (MISO)        7 (MISO)

  NOTE: Also place a 10-100uF cap across the power inputs of
        the NRF24L01+.  I/O o fthe NRF24 is 5V tolerant, but
        do NOT connect more than 3.3V to pin 1!!!
 */

// Set up nRF24L01 radio on SPI bus, and pins 9 (D6) & 10 (A2) on the Shield Shield
RF24 radio(PB_15, PB_14, PB_13, PB_1, PB_2);//*****MOSI MISO SCK CE CS******

const uint64_t send_pipe=0xB01DFACECEL;//These are just arbitrary 64bit numbers to use as pipe identifiers
const uint64_t recv_pipe=0xDEADBEEFF1L;//They must be the same on both ends of the communciations

DigitalOut HLio(PB_12);
Serial pc(SERIAL_TX, SERIAL_RX);


int main()
{

    pc.baud(9600);//Set up comm with the IDE serial monitor
    pc.printf("Ready for commands");
    radio.begin();//Start up the radio object
    radio.setRetries(15,15);//This will improve reliability of the module if it encounters interference
    radio.setPALevel(RF24_PA_LOW);//This sets the power low. This will reduce the range. RF24_PA_MAX would increase the range
    radio.openWritingPipe(send_pipe);//Thses are the reverse of the transmit code.
    radio.openReadingPipe(1,recv_pipe);
    radio.startListening();//Give the module a kick

    while(true) {
        unsigned long motor_code=0;
        HLio = 0;


//        pc.printf("%d\r\n",radio.available());
        if( radio.available()) { //Keep checking on each loop to see if any data has come in
            HLio = 1;
            while(radio.available()) { //Loop while there is incoming data. The packets are one unsigned long in total so it shoudl only loop once
                radio.read(&motor_code, sizeof(unsigned long));//Stuff the incoming packet into the motor_code variable

            }
            HLio = 0;
//            radio.stopListening();//We have heard so now we will send an ack
//            radio.write(&motor_code, sizeof(unsigned long));//Turn the motor code around and send it back
            radio.startListening();//Go back to listening as this is what this mostly does
            
            pc.printf("%d\r\n",motor_code);
            

        }

//    wait_ms(10);
    }

}


