#include "LSM9DS0_SH.h"

//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓GPIO registor↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
//~~~IMU_SPI~~~//
DigitalOut  SPI_CSG(D7,1);      // low for GYRO enable
DigitalOut  SPI_CSXM(D6,1);     // low for ACC/MAG enable
DigitalOut  SPI_CSXM2(D8,1);    // low for ACC/MAG enable

SPI spi(D4, D5, D3);            // MOSI MISO SCLK
//↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑end of GPIO registor↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑//



//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓Varible registor↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
//~~~IMU_SPI~~~//
short low_byte = 0x00;
short high_byte = 0x00;
short Buff = 0x00;

float Wx = 0.0;
float Wy = 0.0;
float Wz = 0.0;

float Ax = 0.0;
float Ay = 0.0;
float Az = 0.0;

float Mx = 0.0;
float My = 0.0;
float Mz = 0.0;

float M2x = 0.0;
float M2y = 0.0;
float M2z = 0.0;
//↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑end of Varible registor↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑//



//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓init_IMU funtion↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
void init_IMU(void)                 //initialize
{
    // gloable config
    SPI_CSXM = 1;                   // high as init for disable SPI
    SPI_CSXM2 = 1;
    SPI_CSG = 1;
    spi.format(8,3);                // byte width, spi mode
    spi.frequency(2000000);         // 2MHz

    // for GYRO config
    SPI_CSG = 0;                    // start spi talking
    spi.write(CTRL_REG1_G);
    spi.write(0xFF);                // data rate 760 Hz / cut off 100 Hz
    SPI_CSG = 1;                    // end spi talking

    SPI_CSG = 0;                    // start spi talking
    spi.write(CTRL_REG4_G);
    spi.write(0x10);                // Scle 500dps
    SPI_CSG = 1;                    // end spi talking

    // for ACC config
    SPI_CSXM = 0;                   // start spi talking
    spi.write(CTRL_REG1_XM);
    spi.write(0x87);                // data rate 400 Hz / Enable
    SPI_CSXM = 1;                   // end spi talking

    SPI_CSXM = 0;                   // start spi talking
    spi.write(CTRL_REG2_XM);
    spi.write(0xC8);                // cut off 50 Hz / Scale +-4g
    SPI_CSXM = 1;                   // end spi talking

    // for MAG config
    SPI_CSXM = 0;                   // start spi talking
    spi.write(CTRL_REG5_XM);
    spi.write(0x10);                // low resolution / data rate 50Hz
    SPI_CSXM = 1;                   // end spi talking

    SPI_CSXM = 0;                   // start spi talking
    spi.write(CTRL_REG6_XM);
    spi.write(0x00);                // scale +-2 gauss
    SPI_CSXM = 1;                   // end spi talking

    SPI_CSXM = 0;                   // start spi talking
    spi.write(CTRL_REG7_XM);
    spi.write(0x00);                // power on
    SPI_CSXM = 1;                   // end spi talking

    // for MAG2 config
    SPI_CSXM2 = 0;                  // start spi talking
    spi.write(CTRL_REG5_XM);
    spi.write(0x10);                // low resolution / data rate 50Hz
    SPI_CSXM2 = 1;                  // end spi talking

    SPI_CSXM2 = 0;                  // start spi talking
    spi.write(CTRL_REG6_XM);
    spi.write(0x00);                // scale +-2 gauss
    SPI_CSXM2 = 1;                  // end spi talking

    SPI_CSXM2 = 0;                  // start spi talking
    spi.write(CTRL_REG7_XM);
    spi.write(0x00);                // power on
    SPI_CSXM2 = 1;                  // end spi talking
}
//↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑end of init_IMU funtion↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑//



//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓read_IMU funtion↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
void read_IMU(void)                     // read IMU data give raw data
{
    // Wx
    SPI_CSG = 0;                        // start spi talking Wx
    spi.write(0xE8);                    // read B11101000 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSG = 1;                        // end spi talking
    Buff = high_byte << 8 | low_byte; 
    Wx = Buff * Gpx;
    // Wy
    SPI_CSG = 0;                        // start spi talking Wy
    spi.write(0xEA);                    // read B11101010 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSG = 1;                        // end spi talking
    Buff = high_byte << 8 | low_byte;
    Wy = Buff * Gpy;
    // Wz
    SPI_CSG = 0;                        // start spi talking Wz
    spi.write(0xEC);                    // read B11101100 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSG = 1;                        // end spi talking
    Buff = high_byte << 8 | low_byte;
    Wz = Buff * Gpz;
    // Ax
    SPI_CSXM = 0;                       // start spi talking Ax
    spi.write(0xE8);                    // read B11101000 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM = 1;                       // end spi talking
    Buff = high_byte << 8 | low_byte;
    Ax = Buff * Apx;
    // Ay
    SPI_CSXM = 0;                       // start spi talking Ay
    spi.write(0xEA);                    // read B11101010 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM = 1;                       // end spi talking
    Buff = high_byte << 8 | low_byte;
    Ay = Buff * Apy;
    // Az
    SPI_CSXM = 0;                       // start spi talking Az
    spi.write(0xEC);                    // read B11101100 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM = 1;                       // end spi talking
    Buff = high_byte << 8 | low_byte;
    Az = Buff * Apz;
    // Mx
    SPI_CSXM = 0;                       // start spi talking Mx
    spi.write(0xC8);                    // read B11001000 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM = 1;                       // end spi talking
    Buff = high_byte << 8 | low_byte;
    Mx = Buff * Mp;
    // My
    SPI_CSXM = 0;                       // start spi talking My
    spi.write(0xCA);                    // read B11001010 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM = 1;                       // end spi talking
    Buff = high_byte << 8 | low_byte;
    My = Buff * Mp;
    // Mz
    SPI_CSXM = 0;                       // start spi talking Mz
    spi.write(0xCC);                    // read B11001100 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM = 1;                       // end spi talking
    Buff = high_byte << 8 | low_byte;
    Mz = Buff * Mp;

    // M2x
    SPI_CSXM2 = 0;                      // start spi talking M2x
    spi.write(0xC8);                    // read B11001000 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM2 = 1;                      // end spi talking
    Buff = high_byte << 8 | low_byte;
    M2x = Buff * Mp;
    // M2y
    SPI_CSXM2 = 0;                      // start spi talking M2y
    spi.write(0xCA);                    // read B11001010 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM2 = 1;                      // end spi talking
    Buff = high_byte << 8 | low_byte;
    M2y = Buff * Mp;
    // M2z
    SPI_CSXM2 = 0;                      // start spi talking M2z
    spi.write(0xCC);                    // read B11001100 read / multi / address
    low_byte = spi.write(0);
    high_byte = spi.write(0);
    SPI_CSXM2 = 1;                      // end spi talking
    Buff = high_byte << 8 |low_byte;
    M2z = Buff * Mp;
}
//↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑end of read_IMU funtion↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑//

