#include "mbed.h"

Ticker timer1;
Serial pc(USBTX, USBRX);
//Serial pc(D10, D2);

union splitter {
    short j;
    char C[2];
    // C[0]就會等於j的lowbyte, C[1]就會等於j的hibyte
};
char T[4] = {255,255,0,0};
int i = 0;
int k = 0;

//函式宣告
void init_TIMER();
void timer1_ITR();
void init_UART();
void UART_TX();

int main()
{
    init_TIMER();
    init_UART();
    while(1) {
    }
}

void init_TIMER()
{
    timer1.attach_us(&timer1_ITR, 1000);  // 1ms進一次timer1中斷
}

void timer1_ITR()
{
    UART_TX();
}

void init_UART()
{
    pc.baud(115200);  // baud rate設為115200
}

void UART_TX()
{
    splitter splitter1;

    //數值範圍：-32768~32768
    splitter1.j = -30000;

    T[2] = splitter1.C[0];
    T[3] = splitter1.C[1];

    while (1) {
        if (pc.writeable() == 1) {
            pc.putc(T[i]);
            i++;
            k++;
        }
        if (k>1) {
            k = 0;
            break;
        }
        if (i>3) {
            i = 0;
            k = 0;
            break;
        }
    }
}