#include "mbed.h"

#define sensor_CTRL_REG_address 0x10
#define sensorG_OUT_X_L_address 0x22
#define sensorX_OUT_X_L_address 0x28
 
SPI spi1(D4, D5, D3);
DigitalOut sensor_CS(D6);

DigitalOut myled(LED1);
Serial pc(D1, D0);

int16_t Gyro_axis_data[3];
int16_t Acce_axis_data[3];

void sensor_setup(void);
void sensorG_read_3axis(void);
void sensorX_read_3axis(void);
 
int main() {
        
    sensor_CS = 1;
    spi1.format(8, 0b11);
    
    sensor_setup();
//    sensor_CS = 0;
//    spi1.write(0x10 | 0x00);
//    spi1.write(0x7C);
//    sensor_CS = 1;
    
    while(1) {
        myled = !myled;
        
//        sensor_CS = 0;
//        spi1.write(0x0F00 | 0x8000);//read reg
//        uint8_t c = spi1.write(0x00);
//        uint8_t c = spi1.write(0x0F00 | 0x8000);
//        spi1.write(0x22 | 0x80);
//        uint8_t c = spi1.write(0x00);
//        sensor_CS = 1;
//        pc.printf("0x%d\r\n", c);
        
        sensorX_read_3axis();
        pc.printf("%d\r\n", Acce_axis_data[1]);
        
        wait_us(100000);
    }
}

void sensor_setup(void)
{
    static unsigned char sensor_CTRL_REG[11];

    sensor_CTRL_REG[1] = 0b01111100; //(10h) XL_ODR = 833Hz, XL_FS = +-8g
    sensor_CTRL_REG[2] = 0b01111100; //(11h) G_ODR = 833Hz, G_FS = 2000dps, LPfc = 110Hz
    sensor_CTRL_REG[3] = 0b00000100; //(12h) register address automatically incremented
    sensor_CTRL_REG[4] = 0b00000000; //(13h) 
    sensor_CTRL_REG[5] = 0b00000000; //(14h) 
    sensor_CTRL_REG[6] = 0b00000000; //(15h)
    sensor_CTRL_REG[7] = 0b00000000; //(16h)
    sensor_CTRL_REG[8] = 0b00000000; //(17h)
    sensor_CTRL_REG[9] = 0b00111000; //(18h) XL_XYZ enable
    sensor_CTRL_REG[10]= 0b00111000; //(19h) G_XYZ enable

    // write mode (R/W = 0)
    sensor_CTRL_REG[0] = sensor_CTRL_REG_address | 0x00; // (10h)

// start
    sensor_CS = 0;
    
    spi1.write(sensor_CTRL_REG[0]);
    spi1.write(sensor_CTRL_REG[1]);
    spi1.write(sensor_CTRL_REG[2]);
    spi1.write(sensor_CTRL_REG[3]);
    spi1.write(sensor_CTRL_REG[4]);
    spi1.write(sensor_CTRL_REG[5]);
    spi1.write(sensor_CTRL_REG[6]);
    spi1.write(sensor_CTRL_REG[7]);
    spi1.write(sensor_CTRL_REG[8]);
    spi1.write(sensor_CTRL_REG[9]);
    spi1.write(sensor_CTRL_REG[10]);
    
    sensor_CS = 1;
// end
}

void sensorG_read_3axis(void)
{
    static unsigned char sensorG_data_write;
    static int  sensorG_data_read[6];

// read mode (R/W = 1)
    sensorG_data_write = sensorG_OUT_X_L_address | 0x80; // write first bit

// start
    sensor_CS = 0;
    
    spi1.write(sensorG_data_write);
    sensorG_data_read[0] = spi1.write(0x00); // XL
    sensorG_data_read[1] = spi1.write(0x00); // XH
    sensorG_data_read[2] = spi1.write(0x00); // YL
    sensorG_data_read[3] = spi1.write(0x00); // YH
    sensorG_data_read[4] = spi1.write(0x00); // ZL
    sensorG_data_read[5] = spi1.write(0x00); // YH
    
    sensor_CS = 1;
// end

    // Data reconstruction  
    Gyro_axis_data[0] = (sensorG_data_read[1]<<8) | sensorG_data_read[0];
    Gyro_axis_data[1] = (sensorG_data_read[3]<<8) | sensorG_data_read[2]; 
    Gyro_axis_data[2] = (sensorG_data_read[5]<<8) | sensorG_data_read[4]; 
}

void sensorX_read_3axis(void)
{
    static unsigned char sensorX_data_write;
    static int  sensorX_data_read[6];

    // read mode (R/W = 1)
    sensorX_data_write = sensorX_OUT_X_L_address | 0x80; // write first bit
    
// start    
    sensor_CS = 0;
    
    spi1.write(sensorX_data_write);
    //accelerater outputs
    sensorX_data_read[0] = spi1.write(0x00); // XL
    sensorX_data_read[1] = spi1.write(0x00); // XH
    sensorX_data_read[2] = spi1.write(0x00); // YL
    sensorX_data_read[3] = spi1.write(0x00); // YH
    sensorX_data_read[4] = spi1.write(0x00); // ZL
    sensorX_data_read[5] = spi1.write(0x00); // ZH
    
    sensor_CS = 1;
// end

    // Data reconstruction
    Acce_axis_data[0] = (sensorX_data_read[1]<<8) | sensorX_data_read[0]; // X
    Acce_axis_data[1] = (sensorX_data_read[3]<<8) | sensorX_data_read[2]; // Y
    Acce_axis_data[2] = (sensorX_data_read[5]<<8) | sensorX_data_read[4]; // Z
    
}