#include "mbed.h"
#include "LPS25H.h"

#define FREQUENCY 0.10

I2C i2c(I2C_SDA, I2C_SCL);
 
DigitalOut myled(LED1);
DigitalIn mybutton(USER_BUTTON);
 
Serial pc(SERIAL_TX, SERIAL_RX);

LPS25H lps25h(i2c);

Ticker timer;
void Int_Timer();

double pres, temp, h, p0=0.0;
double t;

int main(){
    //pc.printf("Start!\n");
    pc.printf("time,pressure,tempreture,height\n");
    // Set reference value
    int i;
    for(i=0; i<10; i++){
        p0 += (double)lps25h.pressure()/4096.0;
        wait(0.1);
    }
    p0/=10;

    //(FREQUENCY)s間隔のタイマー割り込み
    timer.attach(&Int_Timer, FREQUENCY);
    
    t = 0.0;
    //ボタンで終了
    while(1){
        if(mybutton==0){
            timer.detach();
            break;
        }
        myled=!myled;
        wait(0.2);
    } 
    //pc.printf("Finish!\n");
}
 
/** タイマー割り込み **/
void Int_Timer() {
    //char buf[50];
    pres = (double)lps25h.pressure()/4096.0;
    temp = 42.5 + (double)lps25h.temperature()/480.0;
    h = (pow((p0/pres),0.1902)-1.0)*(temp+273.15)/0.0065;

    pc.printf("%.1f,%.2f,%.2f,%.2f\n", t, pres, temp, h);
    //sprintf(buf, "%.2f,%.2f,%.2f,%.2f\n", t, pres, temp, h);
    //fprintf(fp, buf);
    //logger.puts(buf);
    t += FREQUENCY;
}
