#pragma once
#include "Matrix.h"
#include "ErrorLogger.h"

class Vector {
public:
    Vector(int dim);
    ~Vector();
    Vector(const Vector& v);

    Vector& operator=(const Vector& v);
    Vector& operator*=(float c);
    Vector& operator/=(float c);
    Vector& operator+=(const Vector& v);
    Vector& operator-=(const Vector& v);

    void SetComp(int dimNo, float val);
    float GetNorm() const;
    Vector Normalize() const;

    inline int GetDim() const {
        return dim;
    }

    inline const float* GetpComponents() const {
        return (const float*)components;
    }

    inline float GetComp(int dimNo) const {
        if (dimNo > dim) AbortWithMsg("Index Out of Bounds Error !!");
        return components[dimNo-1];
    }

    void CleanUp();

private:
    int dim;
    float* components;

    Vector& operator*=(const Matrix& m);
    Vector& operator*=(const Vector& m);
};

Vector operator+(const Vector& lhv, const Vector& rhv);
Vector operator-(const Vector& lhv, const Vector& rhv);
Vector Cross(const Vector& lhv, const Vector& rhv);
Vector operator*(const float c, const Vector& rhv);
Vector operator*(const Vector& lhv, const float c);
Vector operator*(const Matrix& lhm, const Vector& rhv);
Vector operator*(const Vector& lhv, const Matrix& rhm);
float operator*(const Vector& lhv, const Vector& rhv);

