#pragma once

const static int hmc_addr = 0x3c;

typedef union {
    char reg[6];
    struct {
        uint8_t mag_x_L;
        uint8_t mag_x_H;
        uint8_t mag_y_L;
        uint8_t mag_y_H;
        uint8_t mag_z_L;
        uint8_t mag_z_H;
    } byte;
    
    int16_t value[3];
    
} HMC_DATA;

class HMC5883L {
public:
    HMC5883L(I2C* p_i2c);
    ~HMC5883L();
    
    int init();
    int read();
    
    HMC_DATA data;
    
private:
    I2C* i2c;
};