#include "mbed.h"
 
Serial pc(SERIAL_TX, SERIAL_RX); // tx, rx 
Serial gps(PA_9, PA_10);// tx, rx
 
int main() {
 
      int i,rlock,stn;
      char gps_data[256];
      char ns,ew;
      float time,hokui,tokei;
      float g_hokui,g_tokei;
      float d_hokui,m_hokui,d_tokei,m_tokei;
      int h_time,m_time,s_time;
      
      gps.baud(4800);
      pc.printf("gps start! \r\n");

 
    while (1) {
      i=0;
      while(gps.getc()!='$'){
      }
      
      while( (gps_data[i]=gps.getc()) != '\r'){
        i++;
        if(i==256){
           pc.printf("*** Div Error! ***\r\n");
           i=255;
           break;
         }
      }
      gps_data[i]='\0';
      
    /* test data
    ---- GPS 12:24:43   Lock(1),Stn(6) ----
    Hokui:35.031105
    Tokei:135.773605

    ---- GPS 12:24:44   Lock(1),Stn(6) ----
    Hokui:35.031105
    Tokei:135.773605
    */  
    
      if( sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d",&time,&hokui,&ns,&tokei,&ew,&rlock,&stn) >= 1){
        if(rlock==1){
          //latitude
          d_hokui = int(hokui/100);
          m_hokui = (hokui - d_hokui*100)/60;
          g_hokui = d_hokui + m_hokui;
          //longitude
          d_tokei = int(tokei/100);
          m_tokei = (tokei - d_tokei*100)/60;
          g_tokei=d_tokei + m_tokei;
//          g_hokui=int(hokui/100)+(hokui-int(hokui/100))/60;
//          g_tokei=int(tokei/100)+(tokei-int(tokei/100))/60;
          
          //time set
          h_time = int(time/10000);
          m_time = int((time - h_time*10000)/100);
          s_time = int(time - h_time*10000 - m_time*100);
          h_time=h_time+9;//UTC =>JST
          
          pc.printf("---- GPS %2d:%2d:%2d   ",h_time,m_time,s_time); 
          pc.printf("Lock(%d),Stn(%d) ----\r\n",rlock,stn);  
          // latitude
          pc.printf("Hokui:%4.6f\r\n",g_hokui);
          // longitude 
          pc.printf("Tokei:%4.6f\r\n\n",g_tokei);

          
        }
        else{
          pc.printf("Status:unLock(%d)\r\n",rlock);
          for(i=0;i<40;i++){
            pc.printf("%c",gps_data[i]);
          }
        }
      }//if
    }//while
}//main
 