#include "mbed.h"
#include "Log.h"

DigitalIn mybutton(USER_BUTTON);
Serial pc(SERIAL_TX, SERIAL_RX);

Log logger(SERIAL_TX, SERIAL_RX, SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, "sd");

Ticker timer;
void Int_Timer();
static double t;

int main() {
    /** ログのタイトル行 **/
    char* str="time,button\n";
    if(!(logger.initialize_sdlog(str))){
        return 0;
    }

//    printf("Start!\n");
    timer.attach(&Int_Timer, 0.1);
    
    t = 0.0;
    while(1){
        if(t > 10.0){
            timer.detach();
            break;
        }
    }

    logger.close();
    printf("Finish!\n");
}


void Int_Timer() {
    char buf[20];
    /** ログをとりたい値を記入 **/
    sprintf(buf, "%.1f,%d\n", t, (int)mybutton);
    logger.puts(buf);
    t += 0.1;
}