#include "Log.h"

Log::Log(PinName rx, PinName tx, PinName mosi, PinName miso, PinName sck, PinName cs, const char* name) :
    _device(rx, tx), _sd(mosi, miso, sck, cs, name){
    buf_send.initialize_buffer();
    _device.attach(this, &Log::int_serial_tx, Serial::TxIrq);
}

int Log::initialize_sdlog(const char* str){
    char filename[15];
    int n = find_last();
    if(n < 0) return 0;
    
    //ログ番号を+1してファイルを新規作成
    //ファイル名は"logXXX.csv"
    sprintf(filename, "/sd/log%03d.csv", n+1);
    fp = fopen(filename, "w");
    
    _device.printf(str);
    fprintf(fp, str);
    return 1;
}

void Log::close(){
    wait(0.5);
    fclose(fp);
}

//SDカード内からログ番号の最大値を取得する関数
int Log::find_last() {
    int i, n = 0;
    char c;
    DIR *dp;
    struct dirent *dirst;
    dp = opendir("/sd/");
    if (!dp){
        printf("Could not open directry\n");
        return -1;
    }
    while((dirst = readdir(dp)) != NULL) {
        if(sscanf(dirst->d_name, "log%03d.csv%c", &i, &c) == 1 && i>n) {
            n = i;
        }
    }
    closedir(dp);
    return n;
}

void Log::puts(const char* str){
    int16_t len=strlen(str);
    int16_t capa=buf_send.buffer_capacity();
    bool empty=buf_send.is_buffer_empty();
    char ch;
    if(len>capa){
        len=capa;
    }
    buf_send.write_buffer((const uint8_t*)str, 0, len);
    if((_device.writeable()) && (empty)){
        ch=buf_send.read_buffer_byte();
        _device.putc(ch);
        fputc(ch, fp);
    } 
}

void Log::putc(char ch){
    int16_t capa=buf_send.buffer_capacity();
    if(capa==0) return;
    buf_send.write_buffer_byte(ch);
}

void Log::write_data(uint8_t* buf, int16_t size){
    int capa=buf_send.buffer_capacity();
    if(size>capa){
        size=capa;
    }
    buf_send.write_buffer(buf, 0, size);
}

bool Log::is_empty(){
    return buf_send.is_buffer_empty();
}

int16_t Log::recieve_buffer_size(){
    return buf_recieve.buffer_size();
}

int16_t Log::getc(){
    if(buf_recieve.is_buffer_empty()){
        return -1;
    }
    return buf_recieve.read_buffer_byte();
}

int16_t Log::read_data(uint8_t* buf, int16_t size){
    int len=buf_recieve.buffer_size();
    if(size>len){
        size=len;
    }
    buf_recieve.read_buffer(buf, 0, size);
    return size;
}

char Log::int_tx(){
    return buf_send.read_buffer_byte();
}

void Log::int_serial_tx(){
    char ch;
    while((_device.writeable()) && (buf_send.is_buffer_empty()==false)){
        ch=buf_send.read_buffer_byte();
        _device.putc(ch);
        fputc(ch, fp);
    }
}