#ifndef RING_BUFFER_H_
#define RING_BUFFER_H_

#include "mbed.h"

#define RING_BUFFER_SIZE 512

class RingBuffer{
public:
    void initialize_buffer();
    int16_t buffer_size();
    uint8_t read_buffer_byte();
    int16_t read_buffer_short();
    void read_buffer(uint8_t buf[], int16_t offset, int16_t size); 
    int16_t buffer_capacity();
    void write_buffer_byte(uint8_t ch);
    void write_buffer(const uint8_t buf[], int16_t offset, int16_t size);
    bool is_buffer_empty();

protected:
    uint8_t buffer[RING_BUFFER_SIZE];
    int16_t start;
    int16_t end;
};

#endif /* RING_BUFFER_H_ */