#include "RingBuffer.h"

void RingBuffer::initialize_buffer(){
    start=0;
    end=0;
}

int16_t RingBuffer::buffer_size(){
    if(end >= start){
        return end - start;
    }
    return RING_BUFFER_SIZE - (start - end);
}

uint8_t RingBuffer::read_buffer_byte(){
    uint8_t a;
    a=buffer[start];
    start=(start+1)%RING_BUFFER_SIZE;
    return a;
}

int16_t RingBuffer::read_buffer_short(){
    int16_t a, b;
    a=buffer[start];
    b=buffer[(start+1)%RING_BUFFER_SIZE];
    start=(start+2)%RING_BUFFER_SIZE;
    return (a&0xff)|(b<<8);
}

void RingBuffer::read_buffer(uint8_t buf[], int16_t offset, int16_t size){
    int16_t i;
    uint8_t* p=buf+offset;
    
    for(i=0; i<size; i++){
        *(p++)=buffer[start];
        start=(start+1)%RING_BUFFER_SIZE;
    }
}

int16_t RingBuffer::buffer_capacity(){
    if(end >= start){
        return RING_BUFFER_SIZE-(end-start)-1;
    }
    return (start-end)-1;
}

void RingBuffer::write_buffer_byte(uint8_t ch){
    buffer[end]=ch;
    end=(end+1)%RING_BUFFER_SIZE;
}

void RingBuffer::write_buffer(const uint8_t buf[], int16_t offset, int16_t size){
    int16_t i;
    const uint8_t* p=buf+offset;
    for(i=0; i<size; i++){
        buffer[end]=*(p++);
        end=(end+1)%RING_BUFFER_SIZE;
    }
}

bool RingBuffer::is_buffer_empty(){
    return (start==end);
}