//**** Log.h ****
//ログをリングバッファを用いて、
//シリアル送信、SDカード出力を行う
//***************

#ifndef LOG_H_ 
#define LOG_H_ 

#include "mbed.h"
#include "SDFileSystem.h"
#include "RingBuffer.h"

class Log{
public:
    Log(PinName rx, PinName tx, PinName mosi, PinName miso, PinName sck, PinName cs, const char* name);
    int initialize_sdlog(const char* str);
    void close();
    int find_last();
    void puts(const char *str);
    void putc(char ch);
    void write_data(uint8_t* buf, int16_t size);
    bool is_empty();
    int16_t recieve_buffer_size();
    int16_t getc();
    int16_t read_data(uint8_t* buf, int16_t size);
    char int_tx();
    void int_serial_tx();

protected:
    SDFileSystem _sd;
    FILE *fp;
    Serial _device;
    RingBuffer buf_send;
    RingBuffer buf_recieve;
};

#endif /* LOG_H_ */