#include "mbed.h"
#include <string>
#include <cstring>
//#include "rtos.h"
#include "SRF05.h"
#include "motordriver.h"
Serial bt(p28,p27);//tx,rx
Serial TAG(p9,p10);//tx,rx
Serial pc(USBTX,USBRX);
using namespace std;

void read_line();
void Rx_interrupt();
void move(char in);
// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 255;
// might need to increase buffer size for high baud rates
char rx_buffer[buffer_size+1];
volatile int rx_in=0;
volatile int rx_out=0;
char rx_line[80];

string tagStr1, tagStr2, tagStr3;
bool flag1=false, flag2=false, flag3=false;
string str;

Motor L(p21, p23, p22, 1); // pwm, fwd, rev, can brake ,right
Motor R(p26, p24, p25, 1); // pwm, fwd, rev, can brake ,left
const double speed=0.55;
const double speed_R = 0.85 * speed;
const double speed_L = 1 * speed;
SRF05 srfF(p11, p12);//Trigger,echo
SRF05 srfL(p13, p14);
SRF05 srfR(p7, p8);

int auto_move() {
        //int     d=40; 
        double sp_R=0;
        double sp_L=0;
        
       
        double  r=srfR.read();
        double  l=srfL.read();
        double  w=(r+l)/2;
        
        pc.printf("r = %f l=%f\n\r",r,l);
         /*while(1){
          
         printf("Distancef = %.1f\n",srfF.read());
         printf("DistanceR = %.1f\n",srfR.read());
         printf("DistanceL = %.1f\n",srfL.read());              
            }*/     

//==============go straight beside the wall========================//

        sp_R=speed_R*l/w;
        sp_L=speed_L*r/w;
        R.speed(sp_R),L.speed(sp_L);
//=======================================================//        
        
//==================avoid obstacle=======================//
/**********************************************************     
        if(srfF.read()<=80)
        {
            R.speed(-0.6),L.speed(-0.7);//<80 lower speed            
                
            if(srfF.read()<=20)
            {   R.stop(-0.5),L.stop(-0.5);
                
                if(srfR.read()>=80)
                {
                    wait(0.2);
                    R.speed(-0.6),L.speed(-0.9);//turn right
                    if(srfF.read()>=80)
                    {
                    R.speed(-0.9),L.speed(-1);//forward
                    }
                }
                else
                {
                    wait(0.2);
                    R.speed(-0.7),L.speed(-0.5);//turn left
                    if(srfF.read()>=80)
                    {
                    R.speed(-0.9),L.speed(-1);//forward
                    }                    
                }
            }
         }  
 //**********************************************************/
//============================================================//                
}
void move(char in){
    char ch[1]={'s'};
    ch[0] = in;//in;
   // while(1) {
        //pc.printf("ch[0]= %s\n\r",ch);
     /*   if(bt.readable ()){
            ch[0]=bt.getc();
            //pc.printf("string1 = %s\n\r",ch);
        } */
        switch(ch[0]){
        case 'w':
            //前進
            R.speed(speed_R),L.speed(speed_L);
        break;   
        case 'a':
            //左轉
            R.speed(speed_R),L.speed(0);
        break;
        case 's':
            //停住
            R.stop(0.3),L.stop(0.3);
        break;
        case 'd':
            //右轉
            R.speed(0),L.speed(speed_L);
        break;
        case 'x':
            //backward
            R.speed(-speed_R),L.speed(-speed_L);
        break;
        case 'm':
            //自走車
            pc.printf("auto move");
            auto_move();
        break;
       }  
   // }   
}
//std::string.
int main() {    
    
    bt.baud(38400);
    pc.baud(9600);
    TAG.baud(115200);
    pc.printf("pc hello\n\r");
    bt.printf("bt hello\n\r");
    
    TAG.attach(&Rx_interrupt, Serial::RxIrq);
    char ch = 's' ;
    //Thread thread(move_thread);
    //thread.set_priority(osPriorityLow);
    
    while(1) {

    
        // Read a line from the large rx buffer from rx interrupt routine
        read_line();
        // Read ASCII number from rx line buffer
        //sscanf(rx_line,"%d",&rx_i);
        //pc.printf("string = %s\n\r",rx_line);
        // 若收到藍牙模組的資料，則送到「序列埠監控視窗」
        //pc.printf("tag thread.");
        switch(rx_line[1]){
        case '0':
            flag1=true;
            tagStr1=&rx_line[2];
            //pc.printf("string1 = %s\n\r",tagStr1);
            break;
        case '1':
            flag2=true;
            tagStr2=&rx_line[2];
            //pc.printf("string2 = %s\n\r",tagStr2);
            break;
        case '2':
            flag3=true;
            tagStr3=&rx_line[2];
            //pc.printf("string3 = %s\n\r",tagStr3);
            break;
        }
        if(flag3==true&&flag2==true&&flag1==true){
            flag1=false,flag2=false,flag3=false;
            str=tagStr1+","+tagStr2+","+tagStr3;
            bt.printf("%s\n",str);
        }
        
        if(bt.readable())
            ch=bt.getc();
        move(ch);    
        
        
        
        
        
    }
}
// Read a line from the large rx buffer from rx interrupt routine
void read_line() {
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    rx_line[i-1] = 0;
    return;
}

// Interupt Routine to read in data from serial port
void Rx_interrupt() {
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((TAG.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = TAG.getc();
// Uncomment to Echo to USB serial to watch data flow
//        monitor_TAG.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    return;
}