#include "mbed.h"
#include "Motor.h"

Serial pc(USBTX,USBRX);
AnalogIn ted(p17); // always check
Motor m(p25, p27, p28); // always check
float Lower_distance = 10; //floor 10
float Upper_distance = 20; // floor 20
float Desired_distance = Lower_distance;
float distance;
float analogVal = 0.0;
float mospeed = 0.0;
int time_count;
float floor_error;
float damped_power;
float K = 0.5; // damping value

Timer t;
int main()
{
    // formating
    pc.baud(9600);
    pc.format(7,SerialBase::None,1);

    while(1) {
        time_count = 0;
        while(time_count < 300) {

            analogVal = ted.read(); //reads in the sensor data and sets it to equal analogVal
            pc.printf("%f ", t.read());
            pc.printf("%f\n", distance);
            wait(0.1); // pause
            distance = -124.076*pow(analogVal, 2) + 121.51*analogVal - 8.02;  // equation which changes analogVal to equate to the distance
            // transmit distance data to matlab
            floor_error = Desired_distance - distance; 
            damped_power = K * floor_error; 

            if ( floor_error < -0.25) {
                mospeed = 2.5; //sets motor speed if distance is below desired distance
            } 
            else if ( floor_error > 0.25) {
                mospeed = -2.5; // sets mototr speed if distance is above desired distance
            } 
            else {
                mospeed = 0;
            }
            m.speed(mospeed); // moves motor
            time_count++;
        }
        if ( Desired_distance == Lower_distance){
            Desired_distance = Upper_distance;
        } 
        else{
            Desired_distance = Lower_distance;
        }

    }
}