#include "mbed.h"
#include "board.h"
#include "radio.h"
#include "LoRaMac.h"
#include "Commissioning.h"
#include "SerialDisplay.h"
#include "unixtimestamp.h"
#include <stdio.h>
#include <time.h>


/*!
 * Defines the application data transmission duty cycle. 1s, value in [ms].
 */
#define APP_TX_DUTYCYCLE                            500
#define TAB_MAX                                     20
#define APP_TX_DUTYCYCLE_RND                        5

#define LORAWAN_DEFAULT_DATARATE                    DR_5
#define LORAWAN_CONFIRMED_MSG_ON                    true

/*!
 * LoRaWAN Adaptive Data Rate
 *
 * \remark Please note that when ADR is enabled the end-device should be static
 */
#define LORAWAN_ADR_ON                              1

#include "LoRaMacTest.h"

/*!
 * LoRaWAN ETSI European Telecommunications Standards Institute 
 * duty cycle control enable/disable
 * remark Please note that ETSI mandates duty cycled transmissions. Use only for test purposes
 */
#define LORAWAN_DUTYCYCLE_ON                        false

#define USE_SEMTECH_DEFAULT_CHANNEL_LINEUP          1

//############INITIALISATION LIAISON SERIE####################

void saisie_serie(int tab[6]);
//int tabd[6]= {0,0,0,1,1,2018};
    int tabd[6];

InterruptIn bouton(USER_BUTTON); // Déclaration de l'interruption extern activée par le bouton utilisateur bleu
//Serial pc(USBTX, USBRX); // tx, rx//Serial pc(SERIAL_TX, SERIAL_RX); // Déclaration de entrées pour la liaison série
int etat=0;
void interruption_extern_bouton(void)
{
    etat = not(etat); // changement d'etat
}
//############################################################

#define LC4                { 867100000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 }
#define LC5                { 867300000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 }
#define LC6                { 867500000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 }
#define LC7                { 867700000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 }
#define LC8                { 867900000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 }
#define LC9                { 868800000, { ( ( DR_7 << 4 ) | DR_7 ) }, 2 }
#define LC10               { 868300000, { ( ( DR_6 << 4 ) | DR_6 ) }, 1 }

/*!
 * LoRaWAN application port
 */
#define LORAWAN_APP_PORT                            15

/*!
 * User application data buffer size
 */
#define LORAWAN_APP_DATA_SIZE                       24

static uint8_t DevEui[] = LORAWAN_DEVICE_EUI;
static uint8_t AppEui[] = LORAWAN_APPLICATION_EUI;
static uint8_t AppKey[] = LORAWAN_APPLICATION_KEY;
static uint8_t NwkSKey[] = LORAWAN_NWKSKEY;
static uint8_t AppSKey[] = LORAWAN_APPSKEY;

/*!
 * Device address
 */
static uint32_t DevAddr = LORAWAN_DEVICE_ADDRESS;

/*!
 * Application port
 */
static uint8_t AppPort = LORAWAN_APP_PORT;

/*!
 * User application data size
 */
static uint8_t AppDataSize = LORAWAN_APP_DATA_SIZE;

/*!
 * User application data buffer size
 */
#define LORAWAN_APP_DATA_MAX_SIZE                           64

/*!
 * User application data
 */
static uint8_t AppData[LORAWAN_APP_DATA_MAX_SIZE];

/*!
 * Indicates if the node is sending confirmed or unconfirmed messages
 */
static uint8_t IsTxConfirmed = LORAWAN_CONFIRMED_MSG_ON;

/*!
 * Defines the application data transmission duty cycle
 */
static uint32_t TxDutyCycleTime;

/*!
 * Timer to handle the application data transmission duty cycle
 */
static TimerEvent_t TxNextPacketTimer;

/*
 * Indicates if a new packet can be sent
 */
static bool NextTx = true;

/*!
 * Device states
 */
static enum eDeviceState
{
    DEVICE_STATE_INIT,
    DEVICE_STATE_JOIN,
    DEVICE_STATE_SEND,
    DEVICE_STATE_CYCLE,
    DEVICE_STATE_SLEEP
}DeviceState;

/*!
 * LoRaWAN compliance tests support data
 */
struct ComplianceTest_s
{
    bool Running;
    uint8_t State;
    bool IsTxConfirmed;
    uint8_t AppPort;
    uint8_t AppDataSize;
    uint8_t *AppDataBuffer;
    uint16_t DownLinkCounter;
    bool LinkCheck;
    uint8_t DemodMargin;
    uint8_t NbGateways;
}ComplianceTest;

/*!
 * Indicates if the MAC layer network join status has changed.
 */
static bool IsNetworkJoinedStatusUpdate = false;

/*!
 * Strucure containing the Uplink status
 */
struct sLoRaMacUplinkStatus
{
    uint8_t Acked;
    int8_t Datarate;
    uint16_t UplinkCounter;
    uint8_t Port;
    uint8_t *Buffer;
    uint8_t BufferSize;
}LoRaMacUplinkStatus;
volatile bool UplinkStatusUpdated = false;

/*!
 * Strucure containing the Downlink status
 */
struct sLoRaMacDownlinkStatus
{
    int16_t Rssi;
    int8_t Snr;
    uint16_t DownlinkCounter;
    bool RxData;
    uint8_t Port;
    uint8_t *Buffer;
    uint8_t BufferSize;
}LoRaMacDownlinkStatus;
volatile bool DownlinkStatusUpdated = false;

void SerialDisplayRefresh( int tabd[6] )
{
    MibRequestConfirm_t mibReq;

    SerialDisplayInit( );
    SerialDisplayUpdateActivationMode( OVER_THE_AIR_ACTIVATION );

    SerialDisplayUpdateNwkId( LORAWAN_NETWORK_ID );
    SerialDisplayUpdateDevAddr( DevAddr );
    SerialDisplayUpdateKey( 12, NwkSKey );
    SerialDisplayUpdateKey( 13, AppSKey );
    SerialDisplayUpdateEui( 5, DevEui );
    SerialDisplayUpdateEui( 6, AppEui );
    SerialDisplayUpdateKey( 7, AppKey );

    mibReq.Type = MIB_NETWORK_JOINED;
    LoRaMacMibGetRequestConfirm( &mibReq );
    SerialDisplayUpdateNetworkIsJoined( mibReq.Param.IsNetworkJoined );

    SerialDisplayUpdateAdr( LORAWAN_ADR_ON );
    SerialDisplayUpdateDutyCycle( LORAWAN_DUTYCYCLE_ON );
    SerialDisplayUpdatePublicNetwork( LORAWAN_PUBLIC_NETWORK ); 
    SerialDisplayRTCactive(etat);
    SerialDisplayTIME(tabd);

    //SerialDisplayUpdateLedState( 3, AppLedStateOn );
}

void SerialRxProcess( void )
{
    if( SerialDisplayReadable( ) == true )
    {
        switch( SerialDisplayGetChar( ) )
        {
            case 'R':
            case 'r':
                // Refresh Serial screen
                SerialDisplayRefresh(tabd);
                break;
            default:
                break;
        }
    }
}

/*!
 * \brief   Prepares the payload of the frame
 */
 
int poidstest=34;


typedef struct {
    int heure[8]; // Augmentation taille prog. Solution : heure = pointeur vers malloc (26 ou sizeof ctime)=1bit
    int masse[8];
} data;
data data_packet[TAB_MAX];

//###################################

void copy_time(int data_packet[8],time_t seconds)
{
    char temp[32];
    int tempp;
    //printf("=>%s\n",ctime(&seconds));
    //printf("%d\r\n",seconds);
    sprintf(temp,"%d",(int)seconds);// copie de la valeur de la RTC en cours dans le tableau de structure data_packet
    tempp=atoi(temp);
    Whex_buffer(tempp,data_packet);
}
//##################################

static void PrepareTxFrame( uint8_t port,data datat[TAB_MAX],int compt )//, 2EME PARAMETRE TABLEAU DONNEE INIT=>APPDATA DANS FONCION fournir 1 case tableau data_packet
{        
    switch( port )
    {
    case 15:
        {
           
            for(int h=0;h<8;h++)
            {
                AppData[h]=datat[compt].heure[h];
            } 

           AppData[16]=datat[compt].masse[0];        
        }
        break;
    case 224:
        if( ComplianceTest.LinkCheck == true )
        {
            ComplianceTest.LinkCheck = false;
            AppDataSize = 3;
            AppData[0] = 5;
            AppData[1] = ComplianceTest.DemodMargin;
            AppData[2] = ComplianceTest.NbGateways;
            ComplianceTest.State = 1;
        }
        else
        {
            switch( ComplianceTest.State )
            {
            case 4:
                ComplianceTest.State = 1;
                break;
            case 1:
                AppDataSize = 2;
                AppData[0] = ComplianceTest.DownLinkCounter >> 8;
                AppData[1] = ComplianceTest.DownLinkCounter;
                break;
            }
        }
        break;
    default:
        break;
    }
}

/*!
 * \brief   Prepares the payload of the frame
 *
 * \retval  [0: frame could be send, 1: error]
 */
static bool SendFrame( void )
{
    McpsReq_t mcpsReq;
    LoRaMacTxInfo_t txInfo;

    if( LoRaMacQueryTxPossible( AppDataSize, &txInfo ) != LORAMAC_STATUS_OK )
    {
        // Send empty frame in order to flush MAC commands
        mcpsReq.Type = MCPS_UNCONFIRMED;
        mcpsReq.Req.Unconfirmed.fBuffer = NULL;
        mcpsReq.Req.Unconfirmed.fBufferSize = 0;
        mcpsReq.Req.Unconfirmed.Datarate = LORAWAN_DEFAULT_DATARATE;

        LoRaMacUplinkStatus.Acked = false;
        LoRaMacUplinkStatus.Port = 0;
        LoRaMacUplinkStatus.Buffer = NULL;
        LoRaMacUplinkStatus.BufferSize = 0;
        SerialDisplayUpdateFrameType( false );
    }
    else
    {
        LoRaMacUplinkStatus.Acked = false;
        LoRaMacUplinkStatus.Port = AppPort;
        LoRaMacUplinkStatus.Buffer = AppData;
        LoRaMacUplinkStatus.BufferSize = AppDataSize;
        SerialDisplayUpdateFrameType( IsTxConfirmed );

        if( IsTxConfirmed == false )
        {
            mcpsReq.Type = MCPS_UNCONFIRMED;
            mcpsReq.Req.Unconfirmed.fPort = AppPort;
            mcpsReq.Req.Unconfirmed.fBuffer = AppData;
            mcpsReq.Req.Unconfirmed.fBufferSize = AppDataSize;
            mcpsReq.Req.Unconfirmed.Datarate = LORAWAN_DEFAULT_DATARATE;
        }
        else
        {
            mcpsReq.Type = MCPS_CONFIRMED;
            mcpsReq.Req.Confirmed.fPort = AppPort;
            mcpsReq.Req.Confirmed.fBuffer = AppData;
            mcpsReq.Req.Confirmed.fBufferSize = AppDataSize;
            mcpsReq.Req.Confirmed.NbTrials = 8;
            mcpsReq.Req.Confirmed.Datarate = LORAWAN_DEFAULT_DATARATE;
        }
    }

    if( LoRaMacMcpsRequest( &mcpsReq ) == LORAMAC_STATUS_OK )
    {

        return false;
    }
    return true;

}

/*!
 * \brief Function executed on TxNextPacket Timeout event
 */
static void OnTxNextPacketTimerEvent( void )
{
    MibRequestConfirm_t mibReq;
    LoRaMacStatus_t status;

    TimerStop( &TxNextPacketTimer );

    mibReq.Type = MIB_NETWORK_JOINED;
    status = LoRaMacMibGetRequestConfirm( &mibReq );

    if( status == LORAMAC_STATUS_OK )
    {
        if( mibReq.Param.IsNetworkJoined == true )
        {
            DeviceState = DEVICE_STATE_SEND;
            NextTx = true;
        }
        else
        {
            DeviceState = DEVICE_STATE_JOIN;
        }
    }
}

/*
 * \brief   MCPS-Confirm event function
 *
 * \param   [IN] mcpsConfirm - Pointer to the confirm structure,
 *               containing confirm attributes.
 */
 
static void McpsConfirm( McpsConfirm_t *mcpsConfirm )
{
    if( mcpsConfirm->Status == LORAMAC_EVENT_INFO_STATUS_OK )
    {
        switch( mcpsConfirm->McpsRequest )
        {
            case MCPS_UNCONFIRMED:
            {
                // Check Datarate
                // Check TxPower
                break;
            }
            case MCPS_CONFIRMED:
            {
                // Check Datarate
                // Check TxPower
                // Check AckReceived
                // Check NbTrials
                LoRaMacUplinkStatus.Acked = mcpsConfirm->AckReceived;
                break;
            }
            case MCPS_PROPRIETARY:
            {
                break;
            }
            default:
                break;
        }
        LoRaMacUplinkStatus.Datarate = mcpsConfirm->Datarate;
        LoRaMacUplinkStatus.UplinkCounter = mcpsConfirm->UpLinkCounter;

        /* Switch LED 1 ON
        Led1State = true;
        Led1StateChanged = true;
        TimerStart( &Led1Timer );*/

        UplinkStatusUpdated = true;
    }
    NextTx = true;
}

/*!
 * \brief   MCPS-Indication event function
 *
 * \param   [IN] mcpsIndication - Pointer to the indication structure,
 *               containing indication attributes.
 */
uint8_t c_send=TAB_MAX;
static void McpsIndication( McpsIndication_t *mcpsIndication )
{
    if( mcpsIndication->Status != LORAMAC_EVENT_INFO_STATUS_OK )
    {
        return;
    }

    switch( mcpsIndication->McpsIndication )
    {
        case MCPS_UNCONFIRMED:
        {
            break;
        }
        case MCPS_CONFIRMED:
        {
            break;
        }
        case MCPS_PROPRIETARY:
        {
            break;
        }
        case MCPS_MULTICAST:
        {
            break;
        }
        default:
            break;
    }

    // Check Multicast
    // Check Port
    // Check Datarate
    // Check FramePending
    // Check Buffer
    // Check BufferSize
    // Check Rssi
    // Check Snr
    // Check RxSlot
    LoRaMacDownlinkStatus.Rssi = mcpsIndication->Rssi;
    if( mcpsIndication->Snr & 0x80 ) // The SNR sign bit is 1
    {
        // Invert and divide by 4
        LoRaMacDownlinkStatus.Snr = ( ( ~mcpsIndication->Snr + 1 ) & 0xFF ) >> 2;
        LoRaMacDownlinkStatus.Snr = -LoRaMacDownlinkStatus.Snr;
    }
    else
    {
        // Divide by 4
        LoRaMacDownlinkStatus.Snr = ( mcpsIndication->Snr & 0xFF ) >> 2;
    }
    LoRaMacDownlinkStatus.DownlinkCounter++;
    c_send--;
    LoRaMacDownlinkStatus.RxData = mcpsIndication->RxData;
    LoRaMacDownlinkStatus.Port = mcpsIndication->Port;
    LoRaMacDownlinkStatus.Buffer = mcpsIndication->Buffer;
    LoRaMacDownlinkStatus.BufferSize = mcpsIndication->BufferSize;

    if( ComplianceTest.Running == true )
    {
        ComplianceTest.DownLinkCounter++;
    }

    if( mcpsIndication->RxData == true )
    {
        switch( mcpsIndication->Port )
        {
        case 1: // The application LED can be controlled on port 1 or 2
        case 2:
            /*if( mcpsIndication->BufferSize == 1 )
            {
                AppLedStateOn = mcpsIndication->Buffer[0] & 0x01;
                Led3StateChanged = true;
            }*/
            break;
        case 224:
            if( ComplianceTest.Running == false )
            {
                // Check compliance test enable command (i)
                if( ( mcpsIndication->BufferSize == 4 ) &&
                    ( mcpsIndication->Buffer[0] == 0x01 ) &&
                    ( mcpsIndication->Buffer[1] == 0x01 ) &&
                    ( mcpsIndication->Buffer[2] == 0x01 ) &&
                    ( mcpsIndication->Buffer[3] == 0x01 ) )
                {
                    IsTxConfirmed = false;
                    AppPort = 224;
                    AppDataSize = 2;
                    ComplianceTest.DownLinkCounter = 0;
                    ComplianceTest.LinkCheck = false;
                    ComplianceTest.DemodMargin = 0;
                    ComplianceTest.NbGateways = 0;
                    ComplianceTest.Running = true;
                    ComplianceTest.State = 1;

                    MibRequestConfirm_t mibReq;
                    mibReq.Type = MIB_ADR;
                    mibReq.Param.AdrEnable = true;
                    LoRaMacMibSetRequestConfirm( &mibReq );
                    LoRaMacTestSetDutyCycleOn( false );

                }
            }
            else
            {
                ComplianceTest.State = mcpsIndication->Buffer[0];
                switch( ComplianceTest.State )
                {
                case 0: // Check compliance test disable command (ii)
                    IsTxConfirmed = LORAWAN_CONFIRMED_MSG_ON;
                    AppPort = LORAWAN_APP_PORT;
                    AppDataSize = LORAWAN_APP_DATA_SIZE;
                    ComplianceTest.DownLinkCounter = 0;
                    ComplianceTest.Running = false;

                    MibRequestConfirm_t mibReq;
                    mibReq.Type = MIB_ADR;
                    mibReq.Param.AdrEnable = LORAWAN_ADR_ON;
                    LoRaMacMibSetRequestConfirm( &mibReq );
                    LoRaMacTestSetDutyCycleOn( LORAWAN_DUTYCYCLE_ON );

                    break;
                case 1: // (iii, iv)
                    AppDataSize = 2;
                    break;
                case 2: // Enable confirmed messages (v)
                    IsTxConfirmed = true;
                    ComplianceTest.State = 1;
                    break;
                case 3:  // Disable confirmed messages (vi)
                    IsTxConfirmed = false;
                    ComplianceTest.State = 1;
                    break;
                case 4: // (vii)
                    AppDataSize = mcpsIndication->BufferSize;

                    AppData[0] = 4;
                    for( uint8_t i = 1; i < AppDataSize; i++ )
                    {
                        AppData[i] = mcpsIndication->Buffer[i] + 1;
                    }
                    break;
                case 5: // (viii)
                    {
                        MlmeReq_t mlmeReq;
                        mlmeReq.Type = MLME_LINK_CHECK;
                        LoRaMacMlmeRequest( &mlmeReq );
                    }
                    break;
                case 6: // (ix)
                    {
                        MlmeReq_t mlmeReq;

                        // Disable TestMode and revert back to normal operation
                        IsTxConfirmed = LORAWAN_CONFIRMED_MSG_ON;
                        AppPort = LORAWAN_APP_PORT;
                        AppDataSize = LORAWAN_APP_DATA_SIZE;
                        ComplianceTest.DownLinkCounter = 0;
                        ComplianceTest.Running = false;

                        MibRequestConfirm_t mibReq;
                        mibReq.Type = MIB_ADR;
                        mibReq.Param.AdrEnable = LORAWAN_ADR_ON;
                        LoRaMacMibSetRequestConfirm( &mibReq );
                        LoRaMacTestSetDutyCycleOn( LORAWAN_DUTYCYCLE_ON );
                        mlmeReq.Type = MLME_JOIN;
                        mlmeReq.Req.Join.DevEui = DevEui;
                        mlmeReq.Req.Join.AppEui = AppEui;
                        mlmeReq.Req.Join.AppKey = AppKey;
                        mlmeReq.Req.Join.NbTrials = 3;
                        LoRaMacMlmeRequest( &mlmeReq );
                        DeviceState = DEVICE_STATE_SLEEP;
                    }
                    break;
                case 7: // (x)
                    {
                        if( mcpsIndication->BufferSize == 3 )
                        {
                            MlmeReq_t mlmeReq;
                            mlmeReq.Type = MLME_TXCW;
                            mlmeReq.Req.TxCw.Timeout = ( uint16_t )( ( mcpsIndication->Buffer[1] << 8 ) | mcpsIndication->Buffer[2] );
                            LoRaMacMlmeRequest( &mlmeReq );
                        }
                        else if( mcpsIndication->BufferSize == 7 )
                        {
                            MlmeReq_t mlmeReq;
                            mlmeReq.Type = MLME_TXCW_1;
                            mlmeReq.Req.TxCw.Timeout = ( uint16_t )( ( mcpsIndication->Buffer[1] << 8 ) | mcpsIndication->Buffer[2] );
                            mlmeReq.Req.TxCw.Frequency = ( uint32_t )( ( mcpsIndication->Buffer[3] << 16 ) | ( mcpsIndication->Buffer[4] << 8 ) | mcpsIndication->Buffer[5] ) * 100;
                            mlmeReq.Req.TxCw.Power = mcpsIndication->Buffer[6];
                            LoRaMacMlmeRequest( &mlmeReq );
                        }
                        ComplianceTest.State = 1;
                    }
                    break;
                default:
                    break;
                }
            }
            break;
        default:
            break;
        }
    }

    // Switch LED 2 ON for each received downlink
    //Led2State = true;
    //Led2StateChanged = true;
    //TimerStart( &Led2Timer );
    DownlinkStatusUpdated = true;
}

/*!
 * \brief   MLME-Confirm event function
 *
 * \param   [IN] mlmeConfirm - Pointer to the confirm structure,
 *               containing confirm attributes.
 */
static void MlmeConfirm( MlmeConfirm_t *mlmeConfirm )
{
    switch( mlmeConfirm->MlmeRequest )
    {
        case MLME_JOIN:
        {
            if( mlmeConfirm->Status == LORAMAC_EVENT_INFO_STATUS_OK )
            {
                // Status is OK, node has joined the network
                IsNetworkJoinedStatusUpdate = true;
                DeviceState = DEVICE_STATE_SEND;
            }
            else
            {
                // Join was not successful. Try to join again
                DeviceState = DEVICE_STATE_JOIN;
            }
            break;
        }
        case MLME_LINK_CHECK:
        {
            if( mlmeConfirm->Status == LORAMAC_EVENT_INFO_STATUS_OK )
            {
                // Check DemodMargin
                // Check NbGateways
                if( ComplianceTest.Running == true )
                {
                    ComplianceTest.LinkCheck = true;
                    ComplianceTest.DemodMargin = mlmeConfirm->DemodMargin;
                    ComplianceTest.NbGateways = mlmeConfirm->NbGateways;
                }
            }
            break;
        }
        default:
            break;
    }
    NextTx = true;
    UplinkStatusUpdated = true;
}
 void fil (int tabd[6],time_t seconde)
 {
        char buffer[8];
        strftime(buffer, 8, "%Y\n", localtime(&seconde));
        tabd[5]=atoi(buffer);
        strftime(buffer, 8, "%m\n", localtime(&seconde));
        tabd[4]=atoi(buffer);
        strftime(buffer, 8, "%d\n", localtime(&seconde));
        tabd[3]=atoi(buffer);
        strftime(buffer, 8, "%S\n", localtime(&seconde));
        tabd[2]=atoi(buffer);
        strftime(buffer, 8, "%M\n", localtime(&seconde));
        tabd[1]=atoi(buffer);
        strftime(buffer, 8, "%H\n", localtime(&seconde));
        tabd[0]=atoi(buffer);

}

/*######################################################################
 * Main application entry point.
 */


int main( void )
{
    //####### INITIALISATION MODULE LORA ############
    LoRaMacPrimitives_t LoRaMacPrimitives;
    LoRaMacCallback_t LoRaMacCallbacks;
    MibRequestConfirm_t mibReq;
    BoardInit( );
    SerialDisplayInit( );
    SerialDisplayUpdateEui( 5, DevEui );
    SerialDisplayUpdateEui( 6, AppEui );
    SerialDisplayUpdateKey( 7, AppKey );
    SerialDisplayUpdateNwkId( LORAWAN_NETWORK_ID );
    SerialDisplayUpdateDevAddr( DevAddr );
    SerialDisplayUpdateKey( 12, NwkSKey );
    SerialDisplayUpdateKey( 13, AppSKey );
    DeviceState = DEVICE_STATE_INIT;
    
    //####### LIAISON SERIE ########
    
    /*pc.baud(9600);// vitesse liaison série
    pc.format(8, SerialBase::None, 1);  // format de la liaison*/
    bouton.rise(&interruption_extern_bouton); //initialisation de l'interruption extern sur le bouton user
    
    //####### RTC INIT ########
    //set_time(1514764800);
    int config_s=0;

    //####### VARIABLES ########
    uint8_t compt=0;


    while( 1 )
    {
        if(1)
        {
            SerialRxProcess( );
            if( IsNetworkJoinedStatusUpdate == true )
            {
                IsNetworkJoinedStatusUpdate = false;
                mibReq.Type = MIB_NETWORK_JOINED;
                LoRaMacMibGetRequestConfirm( &mibReq );
                SerialDisplayUpdateNetworkIsJoined( mibReq.Param.IsNetworkJoined );
            }

            if( UplinkStatusUpdated == true )
            {
                UplinkStatusUpdated = false;
                SerialDisplayUpdateUplink( LoRaMacUplinkStatus.Acked, LoRaMacUplinkStatus.Datarate, LoRaMacUplinkStatus.UplinkCounter, LoRaMacUplinkStatus.Port, LoRaMacUplinkStatus.Buffer, LoRaMacUplinkStatus.BufferSize );
            }
            if( DownlinkStatusUpdated == true )
            {
                DownlinkStatusUpdated = false;
                //SerialDisplayUpdateLedState( 2, Led2State );
                SerialDisplayUpdateDownlink( LoRaMacDownlinkStatus.RxData, LoRaMacDownlinkStatus.Rssi, LoRaMacDownlinkStatus.Snr, LoRaMacDownlinkStatus.DownlinkCounter, LoRaMacDownlinkStatus.Port, LoRaMacDownlinkStatus.Buffer, LoRaMacDownlinkStatus.BufferSize );
            }


            
        }
                data_packet[compt].masse[0]=poidstest;              
                poidstest++;
                switch (etat) 
                {
                    
                    case 0:  //bouton non enclenché
                    {            
                        time_t seconds=time(NULL);
                        fil (tabd,seconds);
                        SerialDisplaytest( compt,0 );
                        SerialDisplaytest( c_send,1 );
                        SerialDisplayRTCactive(etat);
                        SerialDisplayTIME(tabd);
                        //time_t seconds = time(NULL)
                        if (compt<=(TAB_MAX-1)||(c_send==0))
                        {
                            if( c_send==0)
                            {
                                compt=0;
                                c_send=TAB_MAX;
                            }
                            wait(3); 
                            //time_t seconds=time(NULL);
                            copy_time(data_packet[compt].heure,seconds); 
                            compt++;                  
                        }

                        else  
                        {  //SerialDisplaytest( compt+1,8 );
                            switch( DeviceState )
                            {
                                case DEVICE_STATE_INIT:
                                {
                                    LoRaMacPrimitives.MacMcpsConfirm = McpsConfirm;
                                    LoRaMacPrimitives.MacMcpsIndication = McpsIndication;
                                    LoRaMacPrimitives.MacMlmeConfirm = MlmeConfirm;
                                    LoRaMacCallbacks.GetBatteryLevel = BoardGetBatteryLevel;
                                    LoRaMacInitialization( &LoRaMacPrimitives, &LoRaMacCallbacks );
                                    TimerInit( &TxNextPacketTimer, OnTxNextPacketTimerEvent );

                                    mibReq.Type = MIB_ADR;
                                    mibReq.Param.AdrEnable = LORAWAN_ADR_ON;
                                    LoRaMacMibSetRequestConfirm( &mibReq );
                                    mibReq.Type = MIB_PUBLIC_NETWORK;
                                    mibReq.Param.EnablePublicNetwork = LORAWAN_PUBLIC_NETWORK;
                                    LoRaMacMibSetRequestConfirm( &mibReq );
                                    LoRaMacTestSetDutyCycleOn( LORAWAN_DUTYCYCLE_ON );
                                    SerialDisplayUpdateDutyCycle( LORAWAN_DUTYCYCLE_ON );


                                    LoRaMacChannelAdd( 3, ( ChannelParams_t )LC4 );
                                    LoRaMacChannelAdd( 4, ( ChannelParams_t )LC5 );
                                    LoRaMacChannelAdd( 5, ( ChannelParams_t )LC6 );
                                    LoRaMacChannelAdd( 6, ( ChannelParams_t )LC7 );
                                    LoRaMacChannelAdd( 7, ( ChannelParams_t )LC8 );
                                    LoRaMacChannelAdd( 8, ( ChannelParams_t )LC9 );
                                    LoRaMacChannelAdd( 9, ( ChannelParams_t )LC10 );

                                    mibReq.Type = MIB_RX2_DEFAULT_CHANNEL;
                                    mibReq.Param.Rx2DefaultChannel = ( Rx2ChannelParams_t ){ 869525000, DR_3 };
                                    LoRaMacMibSetRequestConfirm( &mibReq );

                                    mibReq.Type = MIB_RX2_CHANNEL;
                                    mibReq.Param.Rx2Channel = ( Rx2ChannelParams_t ){ 869525000, DR_3 };
                                    LoRaMacMibSetRequestConfirm( &mibReq );

                                    SerialDisplayUpdateActivationMode( OVER_THE_AIR_ACTIVATION );
                                    SerialDisplayUpdateAdr( LORAWAN_ADR_ON );
                                    SerialDisplayUpdatePublicNetwork( LORAWAN_PUBLIC_NETWORK );

                                    LoRaMacDownlinkStatus.DownlinkCounter = 0;

                                    DeviceState = DEVICE_STATE_JOIN;
                                    
                                    break;
                                }
                                case DEVICE_STATE_JOIN:
                                {
                                    mibReq.Type = MIB_NET_ID;
                                    mibReq.Param.NetID = LORAWAN_NETWORK_ID;
                                    LoRaMacMibSetRequestConfirm( &mibReq );

                                    mibReq.Type = MIB_DEV_ADDR;
                                    mibReq.Param.DevAddr = DevAddr;
                                    LoRaMacMibSetRequestConfirm( &mibReq );

                                    mibReq.Type = MIB_NWK_SKEY;
                                    mibReq.Param.NwkSKey = NwkSKey;
                                    LoRaMacMibSetRequestConfirm( &mibReq );

                                    mibReq.Type = MIB_APP_SKEY;
                                    mibReq.Param.AppSKey = AppSKey;
                                    LoRaMacMibSetRequestConfirm( &mibReq );

                                    mibReq.Type = MIB_NETWORK_JOINED;
                                    mibReq.Param.IsNetworkJoined = true;
                                    LoRaMacMibSetRequestConfirm( &mibReq );
                                   //c_send--;
                                  // SerialDisplaytest( c_send,3 ); 
                                    DeviceState = DEVICE_STATE_SEND;
                                    IsNetworkJoinedStatusUpdate = true;
                                    break;
                                }
                                case DEVICE_STATE_SEND:
                                {   
                                    if(NextTx == true )
                                    {
                                        SerialDisplayUpdateUplinkAcked( false );
                                        SerialDisplayUpdateDonwlinkRxData( false );
                              
                                                         ///prepare tx                                               
                                                        PrepareTxFrame( AppPort,data_packet,compt-c_send);
                                                        NextTx = SendFrame( );
                                                        SerialDisplaytest( compt-c_send,6 );
                                                        
                                          
                                                    
                                    }
                                  
                                    if( ComplianceTest.Running == true )
                                    {
                                        // Schedule next packet transmission
                                        TxDutyCycleTime = 500; // 5000 ms
                                        
                                       
                                        
                                    }
                                    else
                                    {
                                                                               
                                        // Schedule next packet transmission
                                        TxDutyCycleTime = 75;//APP_TX_DUTYCYCLE + randr( -APP_TX_DUTYCYCLE_RND, APP_TX_DUTYCYCLE_RND );
                                    }

                                    DeviceState = DEVICE_STATE_CYCLE;
                                    
                                  
                                   
                                    break;
                                }
                                case DEVICE_STATE_CYCLE:
                                {
                                    //
                                    
                                    
                                    // Schedule next packet transmission
                                    TimerSetValue( &TxNextPacketTimer, TxDutyCycleTime );
                                    TimerStart( &TxNextPacketTimer );
                                    DeviceState = DEVICE_STATE_SLEEP;
                                    break;
                                }
                                case DEVICE_STATE_SLEEP:
                                {
                                    // Wake up through events
                                    break;
                                }
                                default:
                                {
                                    DeviceState = DEVICE_STATE_INIT;
                                    break;
                                }
                                          
                            }
                            
                        }
                    break; 
                    } 
                    case 1 : //bouton enclenché
                    {
                        SerialDisplayRTCactive(etat);
                        saisie_serie(tabd);
                        SerialDisplayTIME(tabd);
                        //chk_and_set_time(tabd);
                        config_s=unix_timestamp(tabd);
                        set_time(config_s);
                        //printf( "%d\r\n",etat);
                        etat=0;
                        break;
                    }
                }
    
                                    
                   
    }
}
