#ifndef __RADIO_EVENT_H__
#define __RADIO_EVENT_H__

#include "dot_util.h"
#include "mDotEvent.h"
#include "C12832.h"

#define TEST_board
//#define REFERENCE_board

#ifdef TEST_board
extern C12832 lcd;
extern uint8_t trx; 
extern uint8_t sent_rx; 

#elif defined(REFERENCE_board)
extern uint8_t received;
extern uint16_t *ptr_rx;

#endif

class RadioEvent : public mDotEvent
{
 
public:
    RadioEvent() {}
 
    virtual ~RadioEvent() {}
 
    /*!
     * MAC layer event callback prototype.
     *
     * \param [IN] flags Bit field indicating the MAC events occurred
     * \param [IN] info  Details about MAC events occurred
     */
    virtual void MacEvent(LoRaMacEventFlags* flags, LoRaMacEventInfo* info) {
 
        if (mts::MTSLog::getLogLevel() == mts::MTSLog::TRACE_LEVEL) {
            std::string msg = "OK";
            switch (info->Status) {
                case LORAMAC_EVENT_INFO_STATUS_ERROR:
                    msg = "ERROR";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_TX_TIMEOUT:
                    msg = "TX_TIMEOUT";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_RX_TIMEOUT:
                    msg = "RX_TIMEOUT";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_RX_ERROR:
                    msg = "RX_ERROR";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_JOIN_FAIL:
                    msg = "JOIN_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_DOWNLINK_FAIL:
                    msg = "DOWNLINK_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_ADDRESS_FAIL:
                    msg = "ADDRESS_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_MIC_FAIL:
                    msg = "MIC_FAIL";
                    break;
                default:
                    break;
            }
            logTrace("Event: %s", msg.c_str());
 
            logTrace("Flags Tx: %d Rx: %d RxData: %d RxSlot: %d LinkCheck: %d JoinAccept: %d",
                     flags->Bits.Tx, flags->Bits.Rx, flags->Bits.RxData, flags->Bits.RxSlot, flags->Bits.LinkCheck, flags->Bits.JoinAccept);
            logTrace("Info: Status: %d ACK: %d Retries: %d TxDR: %d RxPort: %d RxSize: %d RSSI: %d SNR: %d Energy: %d Margin: %d Gateways: %d",
                     info->Status, info->TxAckReceived, info->TxNbRetries, info->TxDatarate, info->RxPort, info->RxBufferSize,
                     info->RxRssi, info->RxSnr, info->Energy, info->DemodMargin, info->NbGateways);
        }
 
        if (flags->Bits.Rx) {
            
            printf("Rx %d bytes \r\n", info->RxBufferSize);                     // Rx 2 bytes
            
            if (info->RxBufferSize > 0) {

#ifdef TEST_board
                
                sent_rx = 1;
                
                uint16_t *ptr_tx = (uint16_t*)(info->RxBuffer);                 // warning! get shifted transmited data; MSByte relevant
                printf("*ptr_tx: %#x\r\n", *ptr_tx);
                *ptr_tx = *ptr_tx >> 8;                                         // shift MSByte to LSByte
                printf("*ptr_tx shift left by 8-bit: %#x\r\n", *ptr_tx);
                
                printf("%#x\r\n",trx);
                
                // print RX data as string and hexadecimal 
                std::string rx((const char*)info->RxBuffer, info->RxBufferSize);
                    
                printf("Rx data: (String):%s (HexString):%s \r\n", rx.c_str(), mts::Text::bin2hexString(info->RxBuffer, info->RxBufferSize).c_str());

                lcd.locate(0,10);
                lcd.printf("Prejeto: %u (+1)", *ptr_tx);
                
                
                if(*ptr_tx == trx+1)                                            // compare received and transmitted+1 value
                {
                   lcd.locate(0,20);
                   lcd.printf("PASS!");   
                   printf("PASS\r\n");

                }
                else
                {
                   lcd.locate(0,20);
                   lcd.printf("FAIL!"); 
                   printf("FAIL\r\n");
                }
                            
                
                
#elif defined(REFERENCE_board)
                
                // get Received value       
                ptr_rx = (uint16_t*)(info->RxBuffer);                           // warning! get shifted transmited data; MSByte relevant
                *ptr_rx = *ptr_rx >> 8;                                         // shift MSByte to LSByte
                printf("*ptr_rx shift left by 8-bit: %#x \r\n", *ptr_rx);
            
                // print RX data as string and hexadecimal    
                std::string rx((const char*)info->RxBuffer, info->RxBufferSize);
                printf("Rx data: (String):%s (HexString):%s \r\n", rx.c_str(), mts::Text::bin2hexString(info->RxBuffer, info->RxBufferSize).c_str());
                          
                received = 1;                                                   // indicate that the RadioEvent has happened
                
                printf("received: %u \r\n", received);
 
#endif
                
            }
        }
    }
};

#endif


