#include "COBS.h"

#include <mbed.h>

Serial pc(PA_2, PA_3);
 

#define ARRAY_SIZE 128
#define NUM_RUNS 200
void printbytes(unsigned char * bytes, unsigned long size){
    
    for(unsigned long i = 0 ; i < size; i++){
        pc.printf("%02X ", bytes[i]);
    }
    pc.printf("\n");
}


//test program for the COBS routines
int main(void){
int err_count = 0;
pc.baud(115200);

pc.printf("COBS Test program\n");


COBS cobs;
unsigned char bytes[ARRAY_SIZE+1];
unsigned char stuffd_bytes[ARRAY_SIZE+1];
unsigned char unstuffd_bytes[ARRAY_SIZE+1];

//run the test NUM_RUNS times
for(int i = 0; i < NUM_RUNS; i++){
//create a random array to test
    for(int bytenum = 0; bytenum < ARRAY_SIZE; bytenum++){
        int byte = rand()>>24;
        if(byte <5) byte = 0;
        bytes[bytenum] = byte;
        }
    
        cobs.StuffData(bytes, ARRAY_SIZE, stuffd_bytes);
        cobs.UnStuffData(stuffd_bytes, ARRAY_SIZE, unstuffd_bytes);

    
    //compare the bytes
    bool error = false;
    for(int bytenum = 0; bytenum < ARRAY_SIZE; bytenum++){
         if(bytes[bytenum] != unstuffd_bytes[bytenum]) error = true;
        }
    
    if(error){ pc.printf("error detected\n");
        pc.printf("Bytes before  stuffing: ");
        printbytes(bytes, ARRAY_SIZE);
        
        pc.printf("Bytes after   stuffing: ");
        printbytes(stuffd_bytes, ARRAY_SIZE+1);
        
        pc.printf("Bytes after unstuffing: ");
        printbytes(unstuffd_bytes, ARRAY_SIZE);
        
        err_count++;
    }
    
    
    }
    
    pc.printf("ran %d times with %d errors", NUM_RUNS, err_count);
        


}