#ifndef __BASE_I2C_DEVICE_H
#define __BASE_I2C_DEVICE_H
#include "mbed.h"

class Base_I2C_Device {
    public:
    Base_I2C_Device(I2C &i2c_p, uint8_t address):i2c(i2c_p), m_address(address) {}
    virtual uint8_t ReadRegisterByte(uint8_t reg);
    virtual uint16_t ReadRegisterWord(uint8_t reg);
    virtual int WriteRegister(uint8_t reg, uint8_t value);
    virtual int WriteRegister(uint8_t reg, uint16_t value) ;
    I2C &i2c;
    virtual char * ReadRegisterMultiByte(uint8_t reg, uint8_t bytes, char * temp_read);
    private:
    uint8_t m_address;
    
    };
  
  
#endif  