#include "Base_I2C_Device.h"




uint8_t Base_I2C_Device::ReadRegisterByte(uint8_t reg)
{
char temp_write[1];
char temp_read[1];

        temp_write[0] = reg;
        i2c.write(m_address, temp_write, 1, true);  // no stop, because we follow with a read
        i2c.read(m_address, temp_read, 1, 0);
                        
        return (uint8_t)temp_read[0];
}
uint16_t Base_I2C_Device::ReadRegisterWord(uint8_t reg)
{
char temp_write[1];
char temp_read[2];

        temp_write[0] = reg;
        i2c.write(m_address, temp_write, 1, true); // no stop, because we follow with a read
        i2c.read(m_address, temp_read, 2, 0);
        
        return (((uint16_t)temp_read[0]) << 8) | (uint16_t)temp_read[1];

}

char * Base_I2C_Device::ReadRegisterMultiByte(uint8_t reg, uint8_t bytes, char * temp_read)
{
char temp_write[1];

        temp_write[0] = reg;
        i2c.write(m_address, temp_write, 1, true);  // no stop, because we follow with a read
        i2c.read(m_address, temp_read, bytes, 0);
	
	return temp_read;

}

int Base_I2C_Device::WriteRegister(uint8_t reg, uint8_t value)   
{
    char temp_write[2];
    
    temp_write[0] = reg;
    temp_write[1] = value;   //check order of these (endianness)
    return i2c.write(m_address, temp_write, 2, false);    
}

int Base_I2C_Device::WriteRegister(uint8_t reg, uint16_t value)   
{
    char temp_write[3];
    
    temp_write[0] = reg;
    temp_write[1] = value>>8;   
    temp_write[2] = (value & 0xFF);
    return i2c.write(m_address, temp_write, 3, false);    
}