#include "mbed.h"
#include <iostream>
#include <cmath>
#include <iomanip>

#include "Keypad.h"

Ticker ticker;
Serial        PC(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9,p10);
CAN can2(p30,p29);
DigitalIn pin21(p21);
DigitalIn pin22(p22);
DigitalIn pin23(p23);
DigitalIn pin24(p24);
DigitalIn pin25(p25);
DigitalIn pin26(p26);
DigitalIn pin27(p27);


//Declare KeyPad GPIO pins here

char Keytable[] = { '1', '2', '3', //row0, p1, mbedpin21
                    '4', '5', '6', //row1, p2, mbedpin22
                    '7', '8', '9', //row2, p3, mbedpin23
                    '*', '0', '#', //row3, p4, mbedpin24
                   };
                    //col0, col1, col2
                    //p5, p6, p7
                    //mbedpin25, mbedpin26, mbedpin27

void functionone(int& Index, int& count);
void functiontwo();
void functionthree();

using namespace std;

int32_t Index;
int32_t count = 0;

uint32_t cbAfterInput(uint32_t index)
{
    Index = index;
    return 0;
}

//Universal ID: 1337
//CAN Message Info
char counter        = '0';    //keypad system CAN test variable
char start          = '*';  //Start
char stop           = '#';  //Stop / Reset
char amp5           = '5';    //Digipot
char amp4           = '4';    //Digipot
char amp3           = '3';    //Digipot
char amp2           = '2';    //Digipot
char amp1           = '1';    //Digipot
char sin10Hz        = 'q';  //DAC -
char sin1Hz         = 'w';  //DAC -
char sqr10Hz        = 'o';  //DAC -
char sqr1Hz         = 't';  //DAC -
char saveUSB        = 'u';  //ADC -0
char saveLocal      = 'l';  //ADC That's an l as in labeorphily
char keypress;


//CAN Send (Parameter = message data) 
void send(char sendMsg) {
    if(can1.write(CANMessage(1337, &sendMsg, 1))) 
    {
        printf("Command sent: %c\n\n", sendMsg);       
    }
    led1 = !led1;  
}


/* write Switch statements*/
//Setup Choice Switch Statements

void functionone(int& Index, int& count)// Get Keypad Input to change Index
{
    while(count == Index)
        {
            Keypad keypad(p21, p22,  p23,  p24, p25, p26,  p27,  NC);
            keypad.attach(&cbAfterInput);
            keypad.start();
        }
    count = Index;

}

void functiontwo() //DAC
{

    int reset = -1;
    
    while(reset == -1)
    {
        cout << "-------------------------------------------------\n\r" << endl;
        cout << "For 10Hz Sine Wave select: 3\n\r" << endl;
        cout << "For 1Hz Sine Wave select: 4\n\r" << endl;
        cout << "For 10Hz Square Wave select: 5\n\r" << endl;
        cout << "For 1Hz Square Wave select: 6\n\r" << endl;
    
    functionone(Index, count);
    
    if (Index == 2)
    {
        cout << "10Hz Sine Wave has been selected \n\r" << endl;
        send(sin10Hz);
        reset = 1; 
    }
    else if (Index == 3)
    {
        cout << "1Hz Sine Wave has been selected\n\r" << endl;
        send(sin1Hz);
        reset = 1;
    }
    else if (Index == 4)
    {
        cout << "10Hz Square Wave has been selected \n\r" << endl;
        send(sqr10Hz);
        reset = 1;
    }
    else if (Index == 5)
    {
        cout << "1Hz Square Wave has been selected \n\r" << endl;
        send(sqr1Hz);
        reset = 1;
    }
    else
    {
        reset = -1;
    }
}
}

void functionthree()//Digipot Config (select amplitude)
{
    int flag = -1;
    
    while (flag == -1)
    {
        cout << "-------------------------------------------------\n\r" << endl;
        cout << "Select Waveform Amplitude\n\r";
        cout << "1V = 1,\n2V = 2,\n3V = 3,\n4V = 4,\n5v = 5\n\r" << endl;
        
        functionone(Index, count);
        
        if (Index == 0)
        {
            send(amp1);
            flag =1;
        }
        else if (Index == 1)
        {
            send(amp2);
            flag = 1;
        }
        else if (Index == 2)
        {
            send(amp3);
            flag = 1;
        }
        else if (Index == 3)
        {
            send(amp4);
            flag = 1;
        }
        else if (Index == 4)
        {
            send(amp5);
            flag = 1;
        }
        else 
        {
            flag = -1;
        }
    }
}

void functionfour() //ADC Config (Save Location Settings)
{
    int flag = -1;
    
    while(flag == -1)
    {
        cout << "-------------------------------------------------\n\r" << endl;
        cout << "Select Save Location:\n\r" << endl;
        cout << "Save Locally (default) = 5, Save to USB = 6\n\r" << endl;
        
        functionone(Index, count);
        
        if (Index == 4)
        {
            cout << "Save locally has been selected\n\r" << endl;
            send(saveLocal);
            flag = 1;
        }
        else if (Index == 5)
        {
            cout << "Save to USB has been selected\n\r" << endl;
            send(saveUSB);
            flag = 1;
        }
        else
        {
            flag =-1;
        }
    }
}

void functionfive()//Start Stop Waveform Command Menu
{
    int flag = -1;

    while(flag == -1)
    {
        cout << "Start/Stop waveform: start = 7, stop = 8 \n\r" << endl;

        functionone(Index, count);

        if (Index ==6)
        {
            cout << "Wave has been started\n\r" << endl;
            send(start);
            flag = 1;
        }
        else if (Index == 7)
        {
            cout << "Wave has been stopped\n\r" << endl;
            send(stop);
            flag = 1;
        }
        else
        {
            flag = -1;
        }
    }
}





int main()
{
    cout << "EE 300 Embedded System Black Box Transfer Function Data Acquisition\n\r" << endl;
    while(1)
    {
        int flag2 = -1;
        
        while(flag2 == -1)
        {
            cout << "-------------------------------------------------\n\r" << endl; 
            cout << "Select Wave Type = 9,\nSelect Wave Amplitude = *,\n\r";
            cout << "Select Save Location =0,\nStart/Stop Wave = #\n\r" << endl;
            functionone(Index, count);
            
            if (Index == 8)//9
            {
                functiontwo();//DAC Config Function
                flag2 = 1;
            }
            else if (Index == 9)//*
            {
                functionthree();//Digipot Config
                flag2 = 1;
            }
            else if (Index == 10) //0
            {
                functionfour();//ADC Config
                flag2 = 1;
            }
            else if (Index == 11)//#
            {
                functionfive();//Start/Stop Waveform Function
                flag2 = 1;
            }
            else
            {
                flag2 = -1;
            }
        }
       
    }
}
